/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleUpdateInputRequiredLabelMigrationStep
extends AbstractMigrationStep<Page> {
    private static final Logger logger = LoggerFactory.getLogger(StyleUpdateInputRequiredLabelMigrationStep.class);
    private AssetService<Page> assetService;

    public StyleUpdateInputRequiredLabelMigrationStep(AssetService<Page> assetService) {
        this.assetService = assetService;
    }

    @Override
    public Optional<MigrationStepReport> migrate(Page artifact) throws IOException {
        for (Asset asset : artifact.getAssets()) {
            if (!asset.getName().equals("style.css")) continue;
            String pageStyleCssContent = this.assetService.getAssetContent(artifact, asset);
            this.assetService.save(artifact, asset, this.getMigratedAssetContent(pageStyleCssContent));
            logger.info("[MIGRATION] Update content property in control-required css class in asset [{}] to {} [{}]", new Object[]{asset.getName(), artifact.getType(), artifact.getName()});
        }
        return Optional.empty();
    }

    private byte[] getMigratedAssetContent(String styleCssContent) {
        String EXTENSION_RESOURCE_REGEX = "((\\.control-label--required:after\\s+\\{)\\s+(content: \"\\*\";))";
        Pattern p = Pattern.compile(EXTENSION_RESOURCE_REGEX);
        Matcher m = p.matcher(styleCssContent);
        StringBuilder buffer = new StringBuilder();
        while (m.find()) {
            if (m.group(2) != null) {
                m.appendReplacement(buffer, m.group(2) + "\n  content: \" *\";");
                continue;
            }
            m.appendTail(buffer);
        }
        m.appendTail(buffer);
        return buffer.toString().getBytes(StandardCharsets.UTF_8);
    }
}

