/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.service.AbstractArtifactService;
import org.bonitasoft.web.designer.service.AssetableArtifactService;

public abstract class AbstractAssetableArtifactService<R extends Repository<T>, T extends Identifiable & Assetable>
extends AbstractArtifactService<R, T>
implements AssetableArtifactService<T> {
    protected AssetService<T> assetService;

    protected AbstractAssetableArtifactService(UiDesignerProperties uiDesignerProperties, AssetService<T> assetService, R repository) {
        super(uiDesignerProperties, repository);
        this.assetService = assetService;
    }

    @Override
    public Asset saveAsset(String id, Asset asset) {
        this.checkUpdatable(id);
        Object identifiable = this.get(id);
        return this.assetService.save(identifiable, asset);
    }

    @Override
    public Asset saveOrUpdateAsset(String id, AssetType assetType, String fileName, byte[] fileContent) {
        this.checkUpdatable(id);
        Object identifiable = this.get(id);
        Asset asset = new Asset().setName(fileName).setType(assetType).setOrder(((Assetable)identifiable).getNextAssetOrder());
        ((Assetable)identifiable).getAssets().stream().filter(arg_0 -> ((Asset)asset).equalsWithoutComponentId(arg_0)).findFirst().ifPresent(existingAsset -> asset.setId(existingAsset.getId()));
        return this.assetService.save(identifiable, asset, fileContent);
    }

    @Override
    public Asset changeAssetOrder(String id, String assetId, AssetService.OrderType orderType) {
        this.checkUpdatable(id);
        Object identifiable = this.get(id);
        return this.assetService.changeAssetOrderInComponent(identifiable, assetId, orderType);
    }

    @Override
    public void changeAssetStateInPreviewable(String id, String assetId, boolean active) {
        this.checkUpdatable(id);
        Object identifiable = this.get(id);
        this.assetService.changeAssetStateInPreviewable(identifiable, assetId, active);
    }

    @Override
    public void deleteAsset(String id, String assetId) {
        this.checkUpdatable(id);
        Object identifiable = this.get(id);
        this.assetService.delete(identifiable, assetId);
    }

    @Override
    public Path findAssetPath(String id, String filename, String type) throws IOException {
        return this.assetService.findAssetPath(id, filename, type);
    }

    protected void checkUpdatable(String id) {
        Objects.requireNonNull(id, "id is null");
    }
}

