/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.rendering.DefaultHtmlGenerator;
import org.bonitasoft.web.designer.DefaultArtifactBuilder;
import org.bonitasoft.web.designer.common.generator.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.controller.export.FragmentExporter;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.importer.AbstractArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PageImporter;
import org.bonitasoft.web.designer.controller.importer.WidgetImporter;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ImporterResolverTest {
    @TempDir
    Path tempDir;
    @Mock
    private ImportStore importStore;
    @Mock
    private PageImporter pageImporter;
    @Mock
    private WidgetImporter widgetImporter;
    @Mock
    private FragmentImporter fragmentImporter;
    private DefaultArtifactBuilder artifactBuilder;

    ImporterResolverTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.artifactBuilder = (DefaultArtifactBuilder)Mockito.spy((Object)new DefaultArtifactBuilder((Workspace)Mockito.mock(Workspace.class), (WidgetService)Mockito.mock(WidgetService.class), (FragmentService)Mockito.mock(FragmentService.class), (PageService)Mockito.mock(PageService.class), (PageExporter)Mockito.mock(PageExporter.class), (FragmentExporter)Mockito.mock(FragmentExporter.class), (WidgetExporter)Mockito.mock(WidgetExporter.class), (HtmlGenerator)Mockito.mock(DefaultHtmlGenerator.class), this.importStore, this.pageImporter, this.fragmentImporter, this.widgetImporter));
        Mockito.lenient().when((Object)this.importStore.store((AbstractArtifactImporter)ArgumentMatchers.any(), (Path)ArgumentMatchers.any())).thenAnswer(invocation -> {
            AbstractArtifactImporter importer = (AbstractArtifactImporter)invocation.getArgument(0);
            Path path = (Path)invocation.getArgument(1);
            String uuid = UUID.randomUUID().toString();
            return new Import(importer, uuid, path);
        });
    }

    @Test
    void should_get_page_importer_from_artifact_type() throws Exception {
        this.artifactBuilder.importPage(this.tempDir, false);
        ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactBuilder)).importFromPath((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (AbstractArtifactImporter)ArgumentMatchers.eq((Object)this.pageImporter));
    }

    @Test
    void should_get_widget_importer_from_artifact_type() throws Exception {
        this.artifactBuilder.importWidget(this.tempDir, false);
        ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactBuilder)).importFromPath((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (AbstractArtifactImporter)ArgumentMatchers.eq((Object)this.widgetImporter));
    }

    @Test
    void should_throw_NotFoundException_for_an_unknown_artifact_type() throws Exception {
        Mockito.when((Object)this.widgetImporter.tryToImportAndGenerateReport((Import)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenThrow(new Throwable[]{new ImportException(ImportException.Type.PAGE_NOT_FOUND, "error")});
        Files.createDirectory(this.tempDir.resolve("resources"), new FileAttribute[0]);
        Throwable throwable = Assertions.catchThrowable(() -> this.artifactBuilder.importWidget(this.tempDir, false));
        Assertions.assertThat((Throwable)throwable).isInstanceOf(ImportException.class);
        ImportException exception = (ImportException)throwable;
        Assertions.assertThat((Comparable)exception.getType()).isEqualTo((Object)ImportException.Type.PAGE_NOT_FOUND);
    }

    @Test
    void should_get_page_importer_from_path() throws Exception {
        Path resources = Files.createDirectory(this.tempDir.resolve("resources"), new FileAttribute[0]);
        Files.createFile(resources.resolve("page.json"), new FileAttribute[0]);
        this.artifactBuilder.importArtifact(this.tempDir, false);
        ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactBuilder)).importFromPath((Path)ArgumentMatchers.eq((Object)this.tempDir), ArgumentMatchers.eq((boolean)false), (AbstractArtifactImporter)ArgumentMatchers.eq((Object)this.pageImporter));
    }

    @Test
    void should_get_widget_importer_from_path() throws Exception {
        Path resources = Files.createDirectory(this.tempDir.resolve("resources"), new FileAttribute[0]);
        Files.createFile(resources.resolve("widget.json"), new FileAttribute[0]);
        this.artifactBuilder.importArtifact(this.tempDir, false);
        ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactBuilder)).importFromPath((Path)ArgumentMatchers.eq((Object)this.tempDir), ArgumentMatchers.eq((boolean)false), (AbstractArtifactImporter)ArgumentMatchers.eq((Object)this.widgetImporter));
    }

    @Test
    void should_get_fragment_importer_from_artifact_type() throws Exception {
        this.artifactBuilder.importFragment((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
        ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactBuilder)).importFromPath((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (AbstractArtifactImporter)ArgumentMatchers.eq((Object)this.fragmentImporter));
    }

    @Test
    void should_get_fragment_importer_from_path() throws Exception {
        Path resources = Files.createDirectory(this.tempDir.resolve("resources"), new FileAttribute[0]);
        Files.createFile(resources.resolve("fragment.json"), new FileAttribute[0]);
        this.artifactBuilder.importArtifact(this.tempDir, false);
        ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactBuilder)).importFromPath((Path)ArgumentMatchers.eq((Object)this.tempDir), ArgumentMatchers.eq((boolean)false), (AbstractArtifactImporter)ArgumentMatchers.eq((Object)this.fragmentImporter));
    }

    @Test
    void should_get_ImportException_while_resources_folder_is_absent() throws Exception {
        Throwable throwable = Assertions.catchThrowable(() -> this.artifactBuilder.importArtifact(this.tempDir, false));
        Assertions.assertThat((Throwable)throwable).isInstanceOf(ImportException.class);
        ImportException exception = (ImportException)throwable;
        Assertions.assertThat((Comparable)exception.getType()).isEqualTo((Object)ImportException.Type.UNEXPECTED_ZIP_STRUCTURE);
        Assertions.assertThat((Throwable)exception).hasMessage("Incorrect zip structure, resources folder is needed");
    }

    @Test
    void should_get_ImportException_while_no_importer_found_from_path() throws Exception {
        Path resources = Files.createFile(this.tempDir.resolve("resources"), new FileAttribute[0]);
        Throwable throwable = Assertions.catchThrowable(() -> this.artifactBuilder.resolveArtifactType(this.tempDir));
        ImportException e = (ImportException)throwable;
        Assertions.assertThat((String)e.getMessage()).isEqualTo("Could not load component, artifact model file not found");
        Assertions.assertThat((Comparable)e.getType()).isEqualTo((Object)ImportException.Type.MODEL_NOT_FOUND);
        Assertions.assertThat((Collection)((Collection)e.getInfos().get("modelfiles"))).containsOnly((Object[])new String[]{"page.json", "widget.json", "fragment.json"});
    }
}

