/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.dependencies;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.controller.importer.dependencies.ComponentDependencyImporter;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.fragment.Fragment;

public class FragmentDependencyImporter
extends ComponentDependencyImporter<Fragment> {
    private final FragmentRepository fragmentRepository;

    public FragmentDependencyImporter(FragmentRepository fragmentRepository) {
        super(fragmentRepository);
        this.fragmentRepository = fragmentRepository;
    }

    @Override
    public List<Fragment> load(Identifiable parent, Path resources) throws IOException {
        Path fragmentsPath = resources.resolve("fragments");
        if (Files.exists(fragmentsPath, new LinkOption[0])) {
            return this.fragmentRepository.loadAll(fragmentsPath);
        }
        return new ArrayList<Fragment>();
    }

    @Override
    public void save(List<Fragment> elements, Path resources) {
        this.fragmentRepository.saveAll(elements);
    }
}

