/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Collection;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class MigrationTabsContainerVisitor
implements ElementVisitor<Void> {
    public Void visit(Container container) {
        container.getRows().stream().flatMap(Collection::stream).forEach(element -> element.accept((ElementVisitor)this));
        return null;
    }

    public Void visit(FormContainer formContainer) {
        return this.visit(formContainer.getContainer());
    }

    public Void visit(TabsContainer tabsContainer) {
        this.createPropertyValue((Component)tabsContainer, "vertical", BondType.CONSTANT, Boolean.FALSE);
        this.createPropertyValue((Component)tabsContainer, "type", BondType.CONSTANT, "tabs");
        for (TabContainer tab : tabsContainer.getTabList()) {
            this.visit(tab);
        }
        return null;
    }

    public Void visit(TabContainer tabContainer) {
        this.createPropertyValue((Component)tabContainer, "cssClasses", BondType.CONSTANT, "");
        this.createPropertyValue((Component)tabContainer, "hidden", BondType.CONSTANT, false);
        this.createPropertyValue((Component)tabContainer, "disabled", BondType.CONSTANT, false);
        this.visit(tabContainer.getContainer());
        return null;
    }

    public Void visit(ModalContainer modalContainer) {
        this.visit(modalContainer.getContainer());
        return null;
    }

    public Void visit(Component component) {
        return null;
    }

    public Void visit(FragmentElement fragmentElement) {
        return null;
    }

    public <P extends Previewable & Identifiable> Void visit(P previewable) {
        previewable.getRows().stream().flatMap(Collection::stream).forEach(element -> element.accept((ElementVisitor)this));
        return null;
    }

    private void createPropertyValue(Component component, String propertyName, BondType bondType, Object defaultValue) {
        if (!component.getPropertyValues().containsKey(propertyName)) {
            PropertyValue newPropertyValue = new PropertyValue();
            newPropertyValue.setType(bondType.toJson());
            newPropertyValue.setValue(defaultValue);
            component.getPropertyValues().put(propertyName, newPropertyValue);
        }
    }
}

