/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class FragmentChangeVisitor
implements ElementVisitor<Set<String>> {
    private String newFragmentId;
    private String fragmentToReplace;

    public Set<String> visit(Container container) {
        this.visitRows(container.getRows());
        return Collections.emptySet();
    }

    public Set<String> visit(FormContainer formContainer) {
        return (Set)formContainer.getContainer().accept((ElementVisitor)this);
    }

    public Set<String> visit(ModalContainer modalContainer) {
        return (Set)modalContainer.getContainer().accept((ElementVisitor)this);
    }

    public Set<String> visit(TabsContainer tabsContainer) {
        for (TabContainer tabContainer : tabsContainer.getTabList()) {
            tabContainer.accept((ElementVisitor)this);
        }
        return Collections.emptySet();
    }

    public Set<String> visit(TabContainer tabContainer) {
        return (Set)tabContainer.getContainer().accept((ElementVisitor)this);
    }

    public Set<String> visit(Component component) {
        return Collections.emptySet();
    }

    public <P extends Previewable & Identifiable> Set<String> visit(P previewable) {
        return Collections.emptySet();
    }

    public Set<String> visit(FragmentElement fragmentElement) {
        if (this.fragmentToReplace.equals(fragmentElement.getId())) {
            fragmentElement.setId(this.newFragmentId);
        }
        return Collections.emptySet();
    }

    public void setNewFragmentId(String newFragmentId) {
        this.newFragmentId = newFragmentId;
    }

    public void setFragmentToReplace(String fragmentToReplace) {
        this.fragmentToReplace = fragmentToReplace;
    }

    public void visitRows(List<List<Element>> rows) {
        rows.forEach(row -> {
            row.stream().filter(Container.class::isInstance).forEach(compo -> {
                Container component = (Container)compo;
                this.visit(component);
            });
            row.stream().filter(FormContainer.class::isInstance).forEach(compo -> {
                FormContainer component = (FormContainer)compo;
                this.visit(component);
            });
            row.stream().filter(TabsContainer.class::isInstance).forEach(compo -> {
                TabsContainer component = (TabsContainer)compo;
                this.visit(component);
            });
            row.stream().filter(ModalContainer.class::isInstance).forEach(compo -> {
                ModalContainer component = (ModalContainer)compo;
                this.visit(component);
            });
            row.stream().filter(FragmentElement.class::isInstance).forEach(compo -> {
                FragmentElement component = (FragmentElement)compo;
                this.visit(component);
            });
        });
    }
}

