/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.List;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;

public class PageHasValidationErrorVisitor {
    public boolean visit(Container container) {
        if (container.getHasValidationError()) {
            return true;
        }
        return this.traverseRow(container.getRows());
    }

    public boolean visit(FormContainer formContainer) {
        return this.visit(formContainer.getContainer());
    }

    public boolean visit(ModalContainer modalContainer) {
        return this.visit(modalContainer.getContainer());
    }

    public boolean visit(TabsContainer tabsContainer) {
        boolean hasValidationError = false;
        for (TabContainer tabContainer : tabsContainer.getTabList()) {
            hasValidationError = hasValidationError || this.visit(tabContainer.getContainer());
        }
        return hasValidationError;
    }

    public boolean visit(Component component) {
        return component.getHasValidationError();
    }

    public <P extends Previewable & Identifiable> boolean visit(P previewable) {
        return false;
    }

    private boolean traverseRow(List<List<Element>> rows) {
        boolean hasValidationError = false;
        for (List<Element> row : rows) {
            for (Element element : row) {
                hasValidationError = hasValidationError || element.getHasValidationError();
            }
        }
        return hasValidationError;
    }
}

