/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.mocks;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.page.Page;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PageImportMock {
    private final PageRepository pageRepositoryMock;
    private final JsonHandler jsonHandlerMock;

    public PageImportMock(PageRepository pageRepositoryMock, JsonHandler jsonHandlerMock) {
        this.pageRepositoryMock = pageRepositoryMock;
        this.jsonHandlerMock = jsonHandlerMock;
    }

    public Page mockPageToBeImported() throws IOException {
        return this.mockPageToBeImported(PageBuilder.aPage().withId("id"));
    }

    public Page mockPageToBeImported(PageBuilder pageBuilder) throws IOException {
        Page page = pageBuilder.build();
        ((JsonHandler)Mockito.lenient().doReturn((Object)page).when((Object)this.jsonHandlerMock)).fromJson((Path)ArgumentMatchers.any(Path.class), (Class)ArgumentMatchers.eq(Page.class), (Class)ArgumentMatchers.eq(JsonViewPersistence.class));
        Mockito.lenient().when((Object)((Page)this.pageRepositoryMock.updateLastUpdateAndSave((Identifiable)page))).thenAnswer(invocationOnMock -> {
            Page pageArg = (Page)invocationOnMock.getArgument(0);
            pageArg.setLastUpdate(Instant.now());
            return pageArg;
        });
        return page;
    }
}

