/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.common.repository.exception.InUseException;
import org.bonitasoft.web.designer.common.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.common.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.exception.NotFoundException;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Form;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.service.DefaultFragmentService;
import org.bonitasoft.web.designer.service.FragmentMigrationApplyer;
import org.bonitasoft.web.designer.visitor.FragmentChangeVisitor;
import org.bonitasoft.web.designer.visitor.PageHasValidationErrorVisitor;
import org.bonitasoft.web.designer.visitor.WebResourcesVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class FragmentServiceTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private FragmentMigrationApplyer fragmentMigrationApplyer;
    @Mock
    private FragmentIdVisitor fragmentIdVisitor;
    @Mock
    private AssetVisitor assetVisitor;
    @InjectMocks
    private DefaultFragmentService fragmentService;

    FragmentServiceTest() {
    }

    @BeforeEach
    void setUp() {
        FragmentChangeVisitor fragmentChangeVisitor = new FragmentChangeVisitor();
        PageHasValidationErrorVisitor pageHasValidationErrorVisitor = new PageHasValidationErrorVisitor();
        this.fragmentService = new DefaultFragmentService(this.fragmentRepository, this.pageRepository, this.fragmentMigrationApplyer, this.fragmentIdVisitor, fragmentChangeVisitor, pageHasValidationErrorVisitor, this.assetVisitor, new UiDesignerProperties("1.13.1", "2.0"), new WebResourcesVisitor(this.fragmentRepository, this.widgetRepository));
        Mockito.lenient().when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        Mockito.lenient().when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        Mockito.lenient().when((Object)((Fragment)this.fragmentRepository.updateLastUpdateAndSave((Identifiable)((Fragment)ArgumentMatchers.any())))).thenAnswer(call -> {
            Fragment fragmentArg = (Fragment)call.getArgument(0);
            fragmentArg.setLastUpdate(Instant.now());
            return fragmentArg;
        });
    }

    @Test
    void should_migrate_found_fragment_when_get_is_called() {
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment fragmentMigrated = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.5.0").withPreviousDesignerVersion("1.0.0").build();
        MigrationResult mr = new MigrationResult((Object)fragmentMigrated, Collections.singletonList(new MigrationStepReport(MigrationStatus.SUCCESS, "myFragmentBis")));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new ArtifactStatusReport(true, false));
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(fragment, true)).thenReturn((Object)mr);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("myFragment"))).thenReturn((Object)fragment);
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(fragment, true);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
    }

    @Test
    void should_not_save_fragment_when_migration_is_not_done() {
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withModelVersion("2.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("myFragment"))).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new ArtifactStatusReport(true, false));
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer, (VerificationMode)Mockito.never())).migrate(fragment, true);
    }

    @Test
    void should_not_save_fragment_when_migration_is_finish_in_error() {
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment fragmentMigrated = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("myFragment"))).thenReturn((Object)fragment);
        MigrationResult mr = new MigrationResult((Object)fragmentMigrated, Collections.singletonList(new MigrationStepReport(MigrationStatus.ERROR, "myFragmentBis")));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new ArtifactStatusReport(true, true));
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(fragment, true)).thenReturn((Object)mr);
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(fragment, true);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
    }

    @Test
    void should_migrate_child_fragment_when_parent_fragment_is_migrate() {
        Fragment fragment = FragmentBuilder.aFragment().withId("myFragmentBis").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment parentFragment = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("1.0.0").with(fragment).withPreviousDesignerVersion("1.0.0").build();
        Fragment fragmentMigrated = FragmentBuilder.aFragment().withId("myFragmentBis").withDesignerVersion("2.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment parentFragmentMigrated = FragmentBuilder.aFragment().withId("myFragment").withDesignerVersion("2.0").withPreviousDesignerVersion("1.0.0").with(fragmentMigrated).build();
        MigrationResult mr = new MigrationResult((Object)fragmentMigrated, Collections.singletonList(new MigrationStepReport(MigrationStatus.SUCCESS, "myFragmentBis")));
        MigrationResult parentMigrated = new MigrationResult((Object)parentFragmentMigrated, Collections.singletonList(new MigrationStepReport(MigrationStatus.SUCCESS, "myFragment")));
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("myFragment"))).thenReturn((Object)parentFragment);
        Mockito.lenient().when((Object)((Fragment)this.fragmentRepository.get("myFragmentBis"))).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new ArtifactStatusReport(true, true));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(parentFragment)).thenReturn((Object)new ArtifactStatusReport(true, true));
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(parentFragment, true)).thenReturn((Object)parentMigrated);
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(fragment, false)).thenReturn((Object)mr);
        HashSet<String> h = new HashSet<String>(Collections.singletonList("myFragmentBis"));
        Mockito.when((Object)this.fragmentRepository.getByIds(h)).thenReturn(Collections.singletonList(fragment));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)parentFragment)).thenReturn(h);
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(parentFragment, true);
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(fragment, false);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)parentFragmentMigrated);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
    }

    @Test
    void should_get_correct_migration_status_when_dependency_is_to_migrate() {
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment").withDesignerVersion("1.10.0").build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        HashSet<String> ids = new HashSet<String>(Collections.singletonList("fragment"));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new ArtifactStatusReport(true, false));
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Collections.singletonList(fragment));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(ids);
        ArtifactStatusReport status = this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(true, true), (Object)status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_dependency_is_not_compatible() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Fragment fragment1 = FragmentBuilder.aFragment().withId("fragment1").withDesignerVersion("1.10.0").build();
        Fragment fragment2 = FragmentBuilder.aFragment().withId("fragment2").withModelVersion("2.1").build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("fragment1", "fragment2"));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment1)).thenReturn((Object)new ArtifactStatusReport(true, false));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment2)).thenReturn((Object)new ArtifactStatusReport(false, false));
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Arrays.asList(fragment1, fragment2));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(ids);
        ArtifactStatusReport status = this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(false, false), (Object)status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_fragment_contains_incompatible_fragment() {
        Fragment fragment1 = FragmentBuilder.aFragment().withId("fragment1").withDesignerVersion("1.10.0").build();
        Fragment fragment2 = FragmentBuilder.aFragment().withId("fragment2").withModelVersion("2.1").build();
        HashSet<String> ids = new HashSet<String>(Collections.singletonList("fragment2"));
        Mockito.lenient().when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment1)).thenReturn((Object)new ArtifactStatusReport(true, false));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment2)).thenReturn((Object)new ArtifactStatusReport(true, false));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)fragment1)).thenReturn(ids);
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Collections.singletonList(fragment2));
        ArtifactStatusReport status = this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)fragment1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(false, false), (Object)status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_dependency_is_not_to_migrate() {
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment").withDesignerVersion("2.0").isMigration(false).build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        HashSet<String> ids = new HashSet<String>(Collections.singletonList("fragment"));
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Collections.singletonList(fragment));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(ids);
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new ArtifactStatusReport(true, false));
        ArtifactStatusReport status = this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(true, false), (Object)status.toString());
    }

    private String getArtifactStatusReport(boolean compatible, boolean migration) {
        return new ArtifactStatusReport(compatible, migration).toString();
    }

    @Test
    void should_create_a_fragment() {
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Collections.emptyList());
        String heidi = "Heidi";
        Fragment fragment = FragmentBuilder.aFragment().withName("Heidi").withId("fragmentId").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(fragment.getName())).thenReturn((Object)"Heidi");
        Fragment savedFragment = this.fragmentService.create(fragment);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo("Heidi");
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)((Fragment)ArgumentMatchers.notNull()));
    }

    @Test
    void should_respond_an_error_when_fragment_name_already_exist() {
        Fragment fragment = FragmentBuilder.aFragment().withName("person").build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Collections.singletonList(fragment));
        Assertions.assertThatThrownBy(() -> this.fragmentService.create(fragment)).isInstanceOf(NotAllowedException.class);
    }

    private Asset aPageAsset() {
        return AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).build();
    }

    private Asset aWidgetAsset() {
        return AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope("widget").withComponentId("widget-id").build();
    }

    @Test
    void should_save_a_fragment() throws Exception {
        Asset pageAsset = this.aPageAsset();
        Asset widgetAsset = this.aWidgetAsset();
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment1").withName("Person").with(new Asset[]{pageAsset, widgetAsset}).withHasValidationError(false).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("fragment1"))).thenReturn((Object)fragment);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus(fragment);
        this.fragmentService.save(fragment.getId(), fragment);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Fragment.class);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)((Fragment)argument.capture()));
        Assertions.assertThat((Object)((Fragment)argument.getValue())).isEqualTo((Object)fragment);
        Assertions.assertThat((Collection)((Fragment)argument.getValue()).getAssets()).containsOnly((Object[])new Asset[]{pageAsset});
    }

    @Test
    void should_respond_422_on_save_when_fragment_is_incompatible() {
        Asset pageAsset = this.aPageAsset();
        Asset widgetAsset = this.aWidgetAsset();
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment1").withName("Person").with(new Asset[]{pageAsset, widgetAsset}).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("fragment1"))).thenReturn((Object)fragment);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(false, false)).when((Object)this.fragmentService)).getStatus(fragment);
        Assertions.assertThatThrownBy(() -> this.fragmentService.save(fragment.getId(), fragment)).isInstanceOf(ModelException.class);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Fragment)ArgumentMatchers.any()));
    }

    @Test
    void should_throw_not_allowed_when_changing_name_and_that_name_already_exist() {
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(FragmentBuilder.aFragment().withId("fragment1").withName("Person").build(), FragmentBuilder.aFragment().withId("fragment2").withName("Persons").build()));
        Fragment fragment = FragmentBuilder.aFragment().withId("fragment1").withName("Persons").build();
        String id = fragment.getId();
        Assertions.assertThatThrownBy(() -> this.fragmentService.save(id, fragment)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_throw_repo_exception_when_error_occurs_while_saving_a_page() {
        Fragment fragment = FragmentBuilder.aFragment().build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragment.getId()))).thenReturn((Object)fragment);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus(fragment);
        Mockito.when((Object)((Fragment)this.fragmentRepository.updateLastUpdateAndSave((Identifiable)fragment))).thenThrow(new Throwable[]{new RepositoryException("exception occured", (Throwable)new Exception())});
        String id = fragment.getId();
        Assertions.assertThatThrownBy(() -> this.fragmentService.save(id, fragment)).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_throw_not_found_when_trying_get_an_unexisting_fragment() {
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("unknownfragment"))).thenThrow(NotFoundException.class);
        Assertions.assertThatThrownBy(() -> this.fragmentService.get("unknownfragment")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_get_all_fragments() {
        Fragment fragment1 = FragmentBuilder.aFragment().withId("fragment1").withName("fragment1").build();
        Fragment fragment2 = FragmentBuilder.aFragment().withId("fragment2").withName("fragment2").build();
        List<Fragment> expectedfragments = Arrays.asList(fragment1, fragment2);
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(expectedfragments);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        List fragments = this.fragmentService.getAllNotUsingFragment(null);
        Assertions.assertThat((List)fragments).hasSameSizeAs(expectedfragments);
        Condition hasStatus = new Condition(f -> f.getStatus() != null, "Status is not null", new Object[0]);
        Assertions.assertThat((Object)((Fragment)fragments.get(0))).is(hasStatus);
        Assertions.assertThat((Object)((Fragment)fragments.get(1))).is(hasStatus);
    }

    @Test
    void should_get_all_fragment_used_elsewhere() {
        Fragment fragment1 = FragmentBuilder.aFragment().withId("fragment1").withName("fragment1").build();
        Fragment fragment2 = FragmentBuilder.aFragment().withId("fragment2").withName("fragment2").build();
        Page page1 = PageBuilder.aPage().build();
        List<Fragment> expectedfragments = Arrays.asList(fragment1, fragment2);
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(expectedfragments);
        String[] ids = new String[]{"fragment1", "fragment2"};
        Mockito.when((Object)this.pageRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(Map.of("fragment1", Collections.singletonList(page1)));
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(Map.of("fragment2", Collections.singletonList(fragment1)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        List fragments = this.fragmentService.getAllNotUsingFragment(null);
        Assertions.assertThat((List)fragments).hasSameSizeAs(expectedfragments);
        ((OptionalAssert)Assertions.assertThat(fragments.stream().filter(o -> o.getName().equals("fragment1")).findFirst()).isPresent()).hasValueSatisfying(fragment -> Assertions.assertThat((List)((List)fragment.getUsedBy().get("page"))).hasSize(1));
        ((OptionalAssert)Assertions.assertThat(fragments.stream().filter(o -> o.getName().equals("fragment2")).findFirst()).isPresent()).hasValueSatisfying(fragment -> Assertions.assertThat((List)((List)fragment.getUsedBy().get("fragment"))).hasSize(1));
    }

    @Test
    void should_get_all_fragment_not_using_a_fragment_id() {
        List<Fragment> expectedfragments = Arrays.asList(FragmentBuilder.aFragment().withId("fragment1").build(), FragmentBuilder.aFragment().withId("fragment2").build());
        Mockito.when((Object)this.fragmentRepository.getAllNotUsingElement("used-fragment")).thenReturn(expectedfragments);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        List fragments = this.fragmentService.getAllNotUsingFragment("used-fragment");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)fragments).hasSameSizeAs(expectedfragments)).anyMatch(o -> o.getId().equals("fragment1"))).anyMatch(o -> o.getId().equals("fragment2"));
    }

    @Test
    void should_get_a_fragment_by_its_id() {
        String fragmentId = "fragment1";
        Fragment fragment1 = FragmentBuilder.aFragment().withId(fragmentId).build();
        ((FragmentRepository)Mockito.doReturn((Object)fragment1).when((Object)this.fragmentRepository)).get(fragmentId);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragment = this.fragmentService.get(fragmentId);
        Assertions.assertThat((String)fragment.getId()).isEqualTo(fragmentId);
        Assertions.assertThat((Collection)fragment.getAssets()).isEmpty();
    }

    @Test
    void should_delete_a_fragment() {
        this.fragmentService.delete("my-fragment");
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).delete("my-fragment");
    }

    @Test
    void should_not_allow_to_delete_a_fragment_used_in_a_page() {
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList("my-fragment"))).thenReturn(Map.of("my-fragment", Collections.singletonList(PageBuilder.aPage().withName("person").build())));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.fragmentService.delete("my-fragment")).isInstanceOf(InUseException.class)).hasMessage("The fragment cannot be deleted because it is used in 1 page <person>");
    }

    @Test
    void should_not_allow_to_delete_a_fragment_used_in_another_fragment() {
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList("my-fragment"))).thenReturn(Map.of("my-fragment", Arrays.asList(FragmentBuilder.aFragment().withName("person1").build(), FragmentBuilder.aFragment().withName("person2").build())));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.fragmentService.delete("my-fragment")).isInstanceOf(InUseException.class)).hasMessage("The fragment cannot be deleted because it is used in 2 fragments <person1>, <person2>");
    }

    @Test
    void should_return_not_found_when_get_inexisting_fragment() {
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("nonExistingFragment"))).thenThrow(new Throwable[]{new NotFoundException("fragment not found")});
        Assertions.assertThatThrownBy(() -> this.fragmentService.get("nonExistingFragment")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_return_not_found_when_delete_inexisting_fragment() {
        ((FragmentRepository)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("fragment not found")}).when((Object)this.fragmentRepository)).delete("my-fragment");
        Assertions.assertThatThrownBy(() -> this.fragmentService.delete("my-fragment")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_return_repo_exception_when_error_on_deletion_fragment() {
        ((FragmentRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RepositoryException("error occurs", (Throwable)new RuntimeException())}).when((Object)this.fragmentRepository)).delete("my-fragment");
        Assertions.assertThatThrownBy(() -> this.fragmentService.delete("my-fragment")).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_rename_a_fragment() throws Exception {
        String newName = "myNewFragment";
        Fragment fragment = FragmentBuilder.aFragment().withName("oldName").withId("myFragment").with(new ElementBuilder[]{ComponentBuilder.anInput()}).build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        this.fragmentService.rename(fragment, newName);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Fragment.class);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)((Fragment)argument.capture()));
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).getNextAvailableId(newName);
        Assertions.assertThat((String)((Fragment)argument.getValue()).getName()).isEqualTo(newName);
        Assertions.assertThat((String)((Fragment)argument.getValue()).getId()).isEqualTo(newName);
        Assertions.assertThat((List)((Fragment)argument.getValue()).getRows()).isEqualTo((Object)fragment.getRows());
        Assertions.assertThat((Collection)((Fragment)argument.getValue()).getAssets()).isEqualTo((Object)fragment.getAssets());
    }

    @Test
    void should_throw_NotAllowedException_when_rename_a_fragment_who_new_name_already_exist() {
        Fragment myFragmentToRename = FragmentBuilder.aFragment().withId("my-fragment").withName("oldName").build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(FragmentBuilder.aFragment().withId("my-fragment1").withName("newName").build(), myFragmentToRename));
        Assertions.assertThatThrownBy(() -> this.fragmentService.rename(myFragmentToRename, "newName")).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_mark_a_page_as_favorite() {
        this.fragmentService.markAsFavorite("my-fragment", true);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).markAsFavorite("my-fragment");
    }

    @Test
    void should_unmark_a_page_as_favorite() {
        this.fragmentService.markAsFavorite("my-fragment", false);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).unmarkAsFavorite("my-fragment");
    }

    @Test
    void should_save_a_fragment_renaming_it() throws Exception {
        Fragment existingFragment = FragmentBuilder.aFragment().withId("myFragment").withName("myFragment").build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("myFragment"))).thenReturn((Object)existingFragment);
        String myNewFragmentId = "myNewFragment";
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().withName(myNewFragmentId).build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(fragmentToBeSaved.getName())).thenReturn((Object)myNewFragmentId);
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment savedFragment = this.fragmentService.save(existingFragment.getId(), fragmentToBeSaved);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToBeSaved);
        Assertions.assertThat((String)savedFragment.getId()).isEqualTo(myNewFragmentId);
    }

    @Test
    void should_update_reference_of_fragment_in_a_page_when_fragment_is_saving_with_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).build();
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("aFragment"))).thenReturn((Object)existingFragment);
        String newFragmentId = "myNewFragment";
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().withName(newFragmentId).build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(fragmentToBeSaved.getName())).thenReturn((Object)newFragmentId);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment savedFragment = this.fragmentService.save(existingFragment.getId(), fragmentToBeSaved);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)page.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(newFragmentId);
        Assertions.assertThat((String)savedFragment.getId()).isEqualTo(newFragmentId);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_use_in_two_container_when_fragment_is_saving_with_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new ElementBuilder[]{ContainerBuilder.aContainer().with(new ElementBuilder[]{ContainerBuilder.aContainer().with(new Element[]{fragmentElement})})}).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("aFragment"))).thenReturn((Object)existingFragment);
        String newFragmentId = "myNewFragment";
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().withName(newFragmentId).build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(fragmentToBeSaved.getName())).thenReturn((Object)newFragmentId);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment savedFragment = this.fragmentService.save(existingFragment.getId(), fragmentToBeSaved);
        Container firstPageContainer = (Container)((List)page.getRows().get(0)).get(0);
        Container secondPageContainer = (Container)((List)firstPageContainer.getRows().get(0)).get(0);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)secondPageContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(newFragmentId);
        Assertions.assertThat((String)savedFragment.getId()).isEqualTo(newFragmentId);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)page.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_use_in_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build()}).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        Container firstPageContainer = (Container)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)firstPageContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_use_in_form_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new ElementBuilder[]{FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build())}).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        FormContainer firstPageContainer = (FormContainer)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)firstPageContainer.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_in_a_modal_container_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new ElementBuilder[]{ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build())}).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        ModalContainer firstPageContainer = (ModalContainer)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)firstPageContainer.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_only_good_fragment_use_in_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        FragmentElement myFragmentElementToKeep = new FragmentElement();
        String myFragmentToKeepId = "myFragmentToKeep";
        myFragmentElementToKeep.setId(myFragmentToKeepId);
        myFragmentElementToKeep.setDimension(Map.of("md", 8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{ContainerBuilder.aContainer().with(new Element[]{fragmentElement, myFragmentElementToKeep}).build()}).build();
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        Container firstPageContainer = (Container)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)firstPageContainer.getRows().get(0)).get(0);
        FragmentElement fragmentToKeepRefInPage = (FragmentElement)((List)firstPageContainer.getRows().get(0)).get(1);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)fragmentToKeepRefInPage.getId()).isEqualTo(myFragmentToKeepId);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_use_in_tab_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        TabsContainerBuilder tabs = TabsContainerBuilder.aTabsContainer().with(new TabContainerBuilder[]{TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build())});
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new ElementBuilder[]{tabs}).build();
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        TabsContainer tabContainer = (TabsContainer)((List)page.getRows().get(0)).get(0);
        Container container = ((TabContainer)tabContainer.getTabList().get(0)).getContainer();
        FragmentElement fragmentRefInPage = (FragmentElement)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_update_reference_of_fragment_in_a_form_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Form form = new Form("myForm");
        form.setId("myForm");
        form.addNewRow((Element)fragmentElement);
        Mockito.when((Object)((Page)this.pageRepository.get(form.getId()))).thenReturn((Object)form);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(form)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        FragmentElement fragmentRefInForm = (FragmentElement)((List)form.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInForm.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)form);
    }

    @Test
    void should_update_reference_of_fragment_in_a_layout_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension(Map.of("md", 8));
        Page layout = PageBuilder.aPage().withId("myLayout").withName("myLayout").withType("layout").with(new Element[]{fragmentElement}).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId("aFragment").withName("aFragment").build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Page)this.pageRepository.get(layout.getId()))).thenReturn((Object)layout);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(layout)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        FragmentElement fragmentRefInPage = (FragmentElement)((List)layout.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInPage.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)layout);
    }

    @Test
    void should_update_reference_of_fragment_in_an_parent_fragment_when_fragment_is_renaming() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId(fragmentChildId);
        fragmentElement.setDimension(Map.of("md", 8));
        Fragment existingFragment = FragmentBuilder.aFragment().withId(fragmentElement.getId()).withName(fragmentChildId).build();
        Fragment fragmentParent = FragmentBuilder.aFragment().withId("fragmentParent").with(new Element[]{fragmentElement}).build();
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentParent.getId()))).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(fragmentParent)));
        Fragment savedFragment = this.fragmentService.rename(existingFragment, newName);
        FragmentElement fragmentRefInFragment = (FragmentElement)((List)fragmentParent.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInFragment.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentParent);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)existingFragment);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).delete(fragmentChildId);
    }

    @Test
    void should_update_reference_of_fragment_in_an_parent_fragment_when_fragment_is_saving_with_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        String fragmentChildId = "fragmentChild";
        fragmentElement.setId(fragmentChildId);
        fragmentElement.setDimension(Map.of("md", 8));
        Fragment fragmentParent = FragmentBuilder.aFragment().withId("fragmentParent").with(new Element[]{fragmentElement}).build();
        Fragment existingFragment = FragmentBuilder.aFragment().withId(fragmentChildId).withName(fragmentChildId).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        String newName = "myNewFragment";
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentElement.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentParent.getId()))).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(fragmentParent)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment savedFragment = this.fragmentService.save(fragmentChildId, FragmentBuilder.aFragment().withName(newName).build());
        FragmentElement fragmentRefInFragment = (FragmentElement)((List)fragmentParent.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentRefInFragment.getId()).isEqualTo(savedFragment.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedFragment.getName()).isEqualTo(newName);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentParent);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).delete(fragmentChildId);
    }

    @Test
    void should_update_to_true_parent_page_when_validation_error_status_changes() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension(Map.of("md", 8));
        fragmentElement.setId("fragmentChild");
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).build();
        page.setHasValidationError(false);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragmentToSave = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        this.fragmentService.save("fragmentChild", fragmentToSave);
        Assertions.assertThat((boolean)page.getHasValidationError()).isTrue();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToSave);
    }

    @Test
    void should_update_to_true_parent_fragment_when_validation_error_status_changes() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension(Map.of("md", 8));
        fragmentElement.setId("fragmentChild");
        Fragment fragmentParent = FragmentBuilder.aFragment().withId("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).build();
        fragmentParent.setHasValidationError(false);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentParent.getId()))).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(fragmentParent)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragmentToSave = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        this.fragmentService.save("fragmentChild", fragmentToSave);
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isTrue();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToSave);
    }

    @Test
    @MockitoSettings(strictness=Strictness.WARN)
    void should_update_to_true_parent_page_of_parent_fragment_when_validation_error_status_changes() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension(Map.of("md", 8));
        fragmentElement.setId("fragmentChild");
        FragmentElement fragmentElementParent = new FragmentElement();
        fragmentElementParent.setHasValidationError(false);
        fragmentElementParent.setDimension(Map.of("md", 8));
        fragmentElementParent.setId("parentFragment");
        Fragment fragmentParent = FragmentBuilder.aFragment().withId("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).build();
        fragmentParent.setHasValidationError(false);
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElementParent}).build();
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        page.setHasValidationError(false);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentParent.getId()))).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(fragmentParent.getId()))).thenReturn(Map.of(fragmentParent.getId(), Collections.singletonList(page)));
        Fragment existingFragment = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(fragmentParent)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragmentToSave = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        this.fragmentService.save("fragmentChild", fragmentToSave);
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isTrue();
        Assertions.assertThat((boolean)page.getHasValidationError()).isTrue();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToSave);
    }

    @Test
    void should_update_to_false_parent_page_when_validation_error_status_changes() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension(Map.of("md", 8));
        fragmentElement.setId("fragmentChild");
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).build();
        page.setHasValidationError(true);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragmentToSave = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        this.fragmentService.save("fragmentChild", fragmentToSave);
        Assertions.assertThat((boolean)page.getHasValidationError()).isFalse();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToSave);
    }

    @Test
    void should_update_to_false_parent_fragment_when_validation_error_status_changes() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension(Map.of("md", 8));
        fragmentElement.setId("fragmentChild");
        Fragment fragmentParent = FragmentBuilder.aFragment().withId("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).build();
        fragmentParent.setHasValidationError(true);
        Fragment existingFragment = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentParent.getId()))).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(fragmentParent)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragmentToSave = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        this.fragmentService.save("fragmentChild", fragmentToSave);
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isFalse();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToSave);
    }

    @Test
    void should_update_to_false_parent_page_of_parent_fragment_when_validation_error_status_changes() throws Exception {
        String fragmentChildId = "fragmentChild";
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(true);
        fragmentElement.setDimension(Map.of("md", 8));
        fragmentElement.setId("fragmentChild");
        FragmentElement fragmentElementParent = new FragmentElement();
        fragmentElementParent.setHasValidationError(true);
        fragmentElementParent.setDimension(Map.of("md", 8));
        fragmentElementParent.setId("parentFragment");
        Fragment fragmentParent = FragmentBuilder.aFragment().withId("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).build();
        fragmentParent.setHasValidationError(true);
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElementParent}).build();
        page.setHasValidationError(true);
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(fragmentParent.getId()))).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(fragmentParent.getId()))).thenReturn(Map.of(fragmentParent.getId(), Collections.singletonList(page)));
        Fragment existingFragment = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get(existingFragment.getId()))).thenReturn((Object)existingFragment);
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(fragmentParent)));
        Mockito.when((Object)this.pageRepository.findByObjectIds(Collections.singletonList(existingFragment.getId()))).thenReturn(Map.of(existingFragment.getId(), Collections.singletonList(page)));
        this.fragmentService = (DefaultFragmentService)Mockito.spy((Object)this.fragmentService);
        ((DefaultFragmentService)Mockito.doReturn((Object)new ArtifactStatusReport(true, false)).when((Object)this.fragmentService)).getStatus((Fragment)ArgumentMatchers.any());
        Fragment fragmentToSave = FragmentBuilder.aFragment().withId("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        this.fragmentService.save("fragmentChild", fragmentToSave);
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isFalse();
        Assertions.assertThat((boolean)page.getHasValidationError()).isFalse();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToSave);
    }
}

