/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.IOException;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.controller.export.ExcludeDescriptorFilePredicate;
import org.bonitasoft.web.designer.controller.export.properties.WidgetPropertiesBuilder;
import org.bonitasoft.web.designer.model.widget.Widget;

public class WidgetByIdExportStep
implements ExportStep<Widget> {
    private final WidgetRepository widgetRepository;
    private final WidgetPropertiesBuilder widgetPropertiesBuilder;

    public void execute(Zipper zipper, Widget widget) throws IOException {
        byte[] widgetProperties = this.widgetPropertiesBuilder.build(widget);
        zipper.addToZip(widgetProperties, "widget.properties");
        zipper.addDirectoryToZip(this.widgetRepository.resolvePath(widget.getId()), Zipper.ALL_DIRECTORIES, (Zipper.FilePredicate)new ExcludeDescriptorFilePredicate(String.format("%s.json", widget.getId())), "resources");
    }

    public WidgetByIdExportStep(WidgetRepository widgetRepository, WidgetPropertiesBuilder widgetPropertiesBuilder) {
        this.widgetRepository = widgetRepository;
        this.widgetPropertiesBuilder = widgetPropertiesBuilder;
    }
}

