/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.exception.JsonReadException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportPathResolver;
import org.bonitasoft.web.designer.controller.importer.ServerImportException;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.HasUUID;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.ArtifactService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactImporter<T extends Identifiable> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractArtifactImporter.class);
    protected final Repository<T> repository;
    protected final JsonHandler jsonHandler;
    private final ArtifactService<T> artifactService;
    private final DependencyImporter<?>[] dependencyImporters;

    protected AbstractArtifactImporter(JsonHandler jsonHandler, ArtifactService<T> artifactService, Repository<T> repository, DependencyImporter<?> ... dependencyImporters) {
        this.jsonHandler = jsonHandler;
        this.repository = repository;
        this.artifactService = artifactService;
        this.dependencyImporters = dependencyImporters;
    }

    public T load(Path path) {
        try {
            Identifiable artifact = (Identifiable)this.jsonHandler.fromJson(path, this.getArtifactType(), JsonViewPersistence.class);
            if (artifact instanceof Widget) {
                ((Widget)artifact).prepareWidgetToDeserialize(path.getParent());
            }
            return (T)artifact;
        }
        catch (JsonProcessingException e) {
            throw new JsonReadException(String.format("Could not read json file [%s]", path.getFileName()), (Exception)((Object)e));
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException(String.format("File not found: [%s]", path.getFileName()));
        }
        catch (IOException e) {
            throw new RepositoryException(String.format("Error while getting component (on file [%s])", path.getFileName()), (Throwable)e);
        }
    }

    protected abstract Class<T> getArtifactType();

    public ImportReport tryToImportAndGenerateReport(Import anImport, boolean ignoreConflicts) {
        Path resources = ImportPathResolver.resolveImportPath(anImport.getPath());
        String modelFile = this.repository.getComponentName() + ".json";
        try {
            ArtifactStatusReport status;
            T element = this.load(resources.resolve(modelFile));
            if (element != null && element.getArtifactVersion() != null && !(status = this.artifactService.getStatusWithoutDependencies(element)).isCompatible()) {
                ImportReport report = new ImportReport((Identifiable)element, null);
                report.setStatus(ImportReport.Status.INCOMPATIBLE);
                return report;
            }
            Map<DependencyImporter, List<?>> dependencies = this.loadArtefactDependencies(element, resources);
            ImportReport report = this.buildReport(element, dependencies);
            report.setUUID(anImport.getUUID());
            if (ignoreConflicts || report.doesNotOverwriteElements()) {
                if (ignoreConflicts) {
                    this.deleteComponentWithSameUUID(report, element);
                }
                this.saveComponent(resources, element, dependencies);
                report.setStatus(ImportReport.Status.IMPORTED);
            } else {
                report.setStatus(ImportReport.Status.CONFLICT);
            }
            return report;
        }
        catch (IOException | RepositoryException e) {
            String errorMessage = "Error while " + (e instanceof IOException ? "unzipping" : "saving") + " artefacts";
            logger.error(errorMessage + ", check uploaded content", e);
            throw new ServerImportException(errorMessage, (Exception)e);
        }
        catch (NotFoundException e) {
            ImportException importException = new ImportException(ImportException.Type.PAGE_NOT_FOUND, String.format("Could not load component, unexpected structure in the file [%s]", modelFile), (Exception)((Object)e));
            importException.addInfo("modelfile", modelFile);
            throw importException;
        }
        catch (JsonReadException e) {
            ImportException importException = new ImportException(ImportException.Type.JSON_STRUCTURE, String.format("Could not read json file [%s]", modelFile), (Exception)((Object)e));
            importException.addInfo("modelfile", modelFile);
            throw importException;
        }
    }

    private void saveComponent(Path resources, T element, Map<DependencyImporter, List<?>> dependencies) throws IOException {
        if (element instanceof HasUUID && this.repository.exists(element.getId())) {
            String newId = this.repository.getNextAvailableId(element.getName());
            ((HasUUID)element).setId(newId);
        }
        this.saveArtefactDependencies(resources, dependencies);
        Identifiable savedElement = this.repository.updateLastUpdateAndSave(element);
        this.artifactService.migrate(savedElement);
    }

    private void deleteComponentWithSameUUID(ImportReport report, T element) {
        Identifiable elementToReplace = report.getOverwrittenElement();
        if (report.isOverwritten() && elementToReplace instanceof HasUUID && elementToReplace.getId() != element.getId()) {
            this.repository.delete(elementToReplace.getId());
        }
    }

    private ImportReport buildReport(T element, Map<DependencyImporter, List<?>> dependencies) {
        ImportReport report = ImportReport.from(element, dependencies);
        if (element instanceof HasUUID) {
            this.checkIfElementWithUUIDIsOverwritten(element, report);
        } else if (this.repository.exists(element.getId())) {
            this.setOverwritten(report, element.getId());
        }
        return report;
    }

    private void checkIfElementWithUUIDIsOverwritten(T element, ImportReport report) {
        String elementUUID = ((HasUUID)element).getUUID();
        Identifiable overwrittenElement = null;
        if (!StringUtils.isEmpty((CharSequence)elementUUID)) {
            overwrittenElement = this.repository.getByUUID(elementUUID);
        } else {
            try {
                UUID.fromString(element.getId());
                logger.info("Imported artifact {} does not have an uuid attribute but its id has the UUID format.The migration will give it an uuid attribute with the same value as its id.", (Object)element.getId());
                overwrittenElement = this.repository.getByUUID(element.getId());
            }
            catch (IllegalArgumentException e) {
                logger.info(String.format("Imported artifact %s does not have an uuid attribute and its id does not have the UUID format.A new UUID will be generated by the migration so it will not replace another artifact.", element.getId()));
            }
        }
        if (overwrittenElement != null) {
            this.setOverwritten(report, overwrittenElement.getId());
        }
    }

    private void setOverwritten(ImportReport report, String elementId) {
        report.setOverwritten(true);
        report.setOverwrittenElement(this.repository.get(elementId));
    }

    private void saveArtefactDependencies(Path resources, Map<DependencyImporter, List<?>> map) {
        for (Map.Entry<DependencyImporter, List<?>> entry : map.entrySet()) {
            entry.getKey().save(entry.getValue(), resources);
        }
    }

    private Map<DependencyImporter, List<?>> loadArtefactDependencies(T element, Path resources) throws IOException {
        HashMap map = new HashMap();
        for (DependencyImporter<?> importer : this.dependencyImporters) {
            map.put(importer, importer.load(element, resources));
        }
        return map;
    }
}

