/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.controller.importer.report.Dependencies;
import org.bonitasoft.web.designer.model.Identifiable;

public class ImportReport {
    private Status status;
    private Identifiable element;
    private Identifiable overwrittenElement;
    private Boolean overwritten = false;
    private Dependencies dependencies;
    private String uuid;

    public ImportReport(Identifiable element, Dependencies dependencies) {
        this.element = element;
        this.dependencies = dependencies;
    }

    public static ImportReport from(Identifiable element, Map<DependencyImporter, List<?>> dependencies) {
        return new ImportReport(element, Dependencies.from(dependencies));
    }

    public Identifiable getElement() {
        return this.element;
    }

    public void setElement(Identifiable element) {
        this.element = element;
    }

    public Identifiable getOverwrittenElement() {
        return this.overwrittenElement;
    }

    public void setOverwrittenElement(Identifiable overwrittenElement) {
        this.overwrittenElement = overwrittenElement;
    }

    public boolean isOverwritten() {
        return this.overwritten;
    }

    public void setOverwritten(Boolean overwritten) {
        this.overwritten = overwritten;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Dependencies dependencies) {
        this.dependencies = dependencies;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @JsonIgnore
    public boolean doesNotOverwriteElements() {
        return !this.isOverwritten() && (this.getDependencies().getOverwritten() == null || this.getDependencies().getOverwritten().isEmpty());
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static enum Status {
        IMPORTED,
        CONFLICT,
        INCOMPATIBLE;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

