/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bonitasoft.web.designer.common.migration.Version;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration<A extends DesignerArtifact> {
    private static final Logger logger = LoggerFactory.getLogger(Migration.class);
    private final Version newArtifactVersion;
    private final MigrationStep<A>[] migrationSteps;

    public Migration(String newArtifactVersion, MigrationStep<A> ... migrationSteps) {
        this.newArtifactVersion = new Version(newArtifactVersion);
        this.migrationSteps = migrationSteps;
    }

    public List<MigrationStepReport> migrate(A artifact) {
        ArrayList<MigrationStepReport> msr = new ArrayList<MigrationStepReport>();
        String artifactVersion = artifact.getArtifactVersion();
        if (artifactVersion == null || this.newArtifactVersion.isGreaterThan(artifactVersion)) {
            logger.info("[MIGRATION] {} <{}> with id <{}> is being migrated from version <{}> to <{}>...", new Object[]{artifact.getClass().getSimpleName(), artifact.getName(), artifact.getId(), this.getDisplayVersion(artifactVersion), this.getDisplayVersion(this.newArtifactVersion.toString())});
            for (MigrationStep<A> migrationStep : this.migrationSteps) {
                try {
                    Optional<MigrationStepReport> report = migrationStep.migrate(artifact);
                    MigrationStepReport stepReport = report.map(r -> {
                        r.setVersion(this.newArtifactVersion.toString());
                        return r;
                    }).orElseGet(MigrationStepReport::successMigrationReport);
                    msr.add(stepReport);
                }
                catch (Exception e) {
                    logger.error("Migration error: {}", (Object)migrationStep.getClass().getName(), (Object)e);
                    msr.add(MigrationStepReport.errorMigrationReport((String)artifact.getId(), (String)migrationStep.getErrorMessage()));
                }
            }
            this.updateVersion(artifact);
            logger.info("[MIGRATION] {} <{}> artifact version is now <{}>", new Object[]{artifact.getClass().getSimpleName(), artifact.getName(), this.newArtifactVersion});
            return msr;
        }
        return msr;
    }

    private String getDisplayVersion(String artifactVersion) {
        if (artifactVersion == null) {
            return "null";
        }
        if (new Version(artifactVersion).isGreaterOrEqualThan("2.0")) {
            return String.format("model version <%s>", artifactVersion);
        }
        return String.format("UI Designer version <%s>", artifactVersion);
    }

    private void updateVersion(A artifact) {
        if (this.isModelVersionMigration()) {
            artifact.setModelVersion(this.newArtifactVersion.toString());
        } else {
            artifact.setDesignerVersion(this.newArtifactVersion.toString());
        }
    }

    private boolean isModelVersionMigration() {
        return this.newArtifactVersion.isGreaterOrEqualThan("2.0");
    }
}

