/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourcesCopier {
    private static final Logger log = LoggerFactory.getLogger(ResourcesCopier.class);

    public void copy(Path destinationPath, String patternLocation) throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resolver.getResources("classpath*:/" + patternLocation + "/**")) {
            if (resource.exists() && resource.isReadable() && resource.contentLength() > 0L) {
                URL url = resource.getURL();
                String urlString = url.toExternalForm();
                String targetName = urlString.substring(urlString.indexOf(patternLocation));
                File destination = new File(destinationPath.toAbsolutePath().toFile(), targetName);
                FileUtils.copyURLToFile((URL)url, (File)destination);
                log.debug("Copied " + url + " to " + destination.getAbsolutePath());
                continue;
            }
            log.debug("Did not copy, seems to be directory: " + resource.getDescription());
        }
    }
}

