/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.contract.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.ContractInputContainer;
import org.bonitasoft.web.designer.model.contract.DataReference;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.NodeContractInput;

public class ContractDeserializer
extends JsonDeserializer<Contract> {
    public Contract deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = parser.getCodec();
        ObjectNode treeNode = (ObjectNode)oc.readTree(parser);
        Contract contract = new Contract();
        this.parseNodeContractInput(this.childInput((JsonNode)treeNode), contract);
        return contract;
    }

    private void parseNodeContractInput(ArrayNode inputArray, ContractInputContainer rootNodeInput) throws IOException {
        for (int i = 0; i < inputArray.size(); ++i) {
            JsonNode childNode = inputArray.get(i);
            Class<?> inputType = this.inputType(childNode);
            if (inputType.equals(NodeContractInput.class)) {
                NodeContractInput nodeContractInput = this.newNodeContractInput(childNode);
                rootNodeInput.addInput(nodeContractInput);
                this.parseNodeContractInput(this.childInput(childNode), nodeContractInput);
                continue;
            }
            rootNodeInput.addInput(this.newLeafContractInput(childNode, inputType));
        }
    }

    private NodeContractInput newNodeContractInput(JsonNode childNode) {
        NodeContractInput nodeContractInput = new NodeContractInput(this.inputName(childNode));
        nodeContractInput.setMandatory(this.mandatoryValue(childNode));
        nodeContractInput.setMultiple(this.multipleValue(childNode));
        nodeContractInput.setDescription(this.descriptionValue(childNode));
        nodeContractInput.setDataReference(this.dataReference(childNode));
        nodeContractInput.setMode(this.inputMode(childNode));
        nodeContractInput.setReadonly(this.readOnlyValue(childNode));
        return nodeContractInput;
    }

    private LeafContractInput newLeafContractInput(JsonNode childNode, Class<?> inputType) {
        LeafContractInput leafContractInput = new LeafContractInput(this.inputName(childNode), inputType);
        leafContractInput.setMandatory(this.mandatoryValue(childNode));
        leafContractInput.setMultiple(this.multipleValue(childNode));
        leafContractInput.setDescription(this.descriptionValue(childNode));
        leafContractInput.setDataReference(this.dataReference(childNode));
        leafContractInput.setMode(this.inputMode(childNode));
        leafContractInput.setReadonly(this.readOnlyValue(childNode));
        return leafContractInput;
    }

    private Class<?> inputType(JsonNode childNode) throws IOException {
        Class<?> inputType;
        try {
            inputType = Class.forName(this.classNameValue(childNode));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(String.format("Failed to create LeafContractInput with type %s", this.classNameValue(childNode)), e);
        }
        return inputType;
    }

    private ArrayNode childInput(JsonNode treeNode) {
        return treeNode.has("input") ? treeNode.get("input") : new ArrayNode(JsonNodeFactory.instance);
    }

    private String classNameValue(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("type");
        return jsonNode != null ? jsonNode.asText(String.class.getName()) : String.class.getName();
    }

    private String descriptionValue(JsonNode contractInput) {
        JsonNode descriptionNode = contractInput.get("description");
        return descriptionNode != null ? descriptionNode.asText(null) : null;
    }

    private boolean multipleValue(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("multiple");
        return jsonNode != null ? jsonNode.asBoolean(false) : false;
    }

    private boolean mandatoryValue(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("mandatory");
        return jsonNode != null ? jsonNode.asBoolean(false) : false;
    }

    private String inputName(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("name");
        return jsonNode != null ? jsonNode.asText("") : "";
    }

    private DataReference dataReference(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("dataReference");
        if (jsonNode != null && !jsonNode.isNull()) {
            boolean isBusinessDataRef = jsonNode.get("relationType") != null && !jsonNode.get("relationType").isNull();
            return isBusinessDataRef ? new BusinessDataReference(jsonNode.get("name").asText(), jsonNode.get("type").asText(), BusinessDataReference.RelationType.valueOf(jsonNode.get("relationType").asText()), BusinessDataReference.LoadingType.valueOf(jsonNode.get("loadingType").asText())) : new DataReference(jsonNode.get("name").asText(), jsonNode.get("type").asText());
        }
        return null;
    }

    private EditMode inputMode(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("mode");
        return jsonNode != null ? EditMode.valueOf(jsonNode.asText("")) : EditMode.CREATE;
    }

    private boolean readOnlyValue(JsonNode contractInput) {
        JsonNode jsonNode = contractInput.get("readOnly");
        return jsonNode != null ? jsonNode.asBoolean(false) : false;
    }

    public Class<?> handledType() {
        return Contract.class;
    }
}

