/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.contract.databind;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.NodeContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.contract.databind.ContractDeserializer;
import org.junit.Test;

public class ContractDeserializerTest {
    @Test
    public void deserialize_a_serialized_contract_json_document_into_a_contract_object() throws Exception {
        Contract aSimpleContract = ContractBuilder.aSimpleContract();
        byte[] serializedContract = new ObjectMapper().writeValueAsBytes((Object)aSimpleContract);
        ContractDeserializer contractDeserializer = new ContractDeserializer();
        Contract contract = contractDeserializer.deserialize(new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(serializedContract), null);
        Assertions.assertThat((List)contract.getInput()).extracting(new String[]{"name", "type"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"name", String.class.getName()}), Assertions.tuple((Object[])new Object[]{"isValid", Boolean.class.getName()}), Assertions.tuple((Object[])new Object[]{"ticket", NodeContractInput.class.getName()})});
        Assertions.assertThat((List)((ContractInput)Iterables.find((Iterable)contract.getInput(), (Predicate)Predicates.instanceOf(NodeContractInput.class))).getInput()).extracting(new String[]{"name", "type"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"title", String.class.getName()}), Assertions.tuple((Object[])new Object[]{"creationDate", Date.class.getName()}), Assertions.tuple((Object[])new Object[]{"creationLocalDate", LocalDate.class.getName()}), Assertions.tuple((Object[])new Object[]{"creationLocalDateTime", LocalDateTime.class.getName()}), Assertions.tuple((Object[])new Object[]{"creationOffsetDateTime", OffsetDateTime.class.getName()}), Assertions.tuple((Object[])new Object[]{"updateTime", Long.class.getName()})});
    }

    @Test
    public void should_handle_serialization_of_a_contract_with_data_references() throws Exception {
        Contract aSimpleContractWithDataRef = ContractBuilder.aSimpleContractWithDataRef(EditMode.EDIT);
        byte[] serializedContract = new ObjectMapper().writeValueAsBytes((Object)aSimpleContractWithDataRef);
        ContractDeserializer contractDeserializer = new ContractDeserializer();
        Contract contract = contractDeserializer.deserialize(new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(serializedContract), null);
        Assertions.assertThat((List)contract.getInput()).extracting(new String[]{"name", "type", "dataReference"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"employeeInput", NodeContractInput.class.getName(), new BusinessDataReference("employee", "org.test.Employee", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)})});
        Assertions.assertThat((List)((ContractInput)Iterables.find((Iterable)contract.getInput(), (Predicate)Predicates.instanceOf(NodeContractInput.class))).getInput()).extracting(new String[]{"name", "type"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"firstName", String.class.getName()}), Assertions.tuple((Object[])new Object[]{"lastName", String.class.getName()}), Assertions.tuple((Object[])new Object[]{"birthDate", LocalDate.class.getName()}), Assertions.tuple((Object[])new Object[]{"manager", NodeContractInput.class.getName()}), Assertions.tuple((Object[])new Object[]{"addresses", NodeContractInput.class.getName()})});
    }

    @Test
    public void handle_contract_type() throws Exception {
        ContractDeserializer contractDeserializer = new ContractDeserializer();
        Assertions.assertThat((Class)contractDeserializer.handledType()).isEqualTo(Contract.class);
    }

    @Test
    public void deserialize_an_contact_with_an_input_without_name() throws Exception {
        Contract anEmptyContract = ContractBuilder.aContract().withInput(ContractInputBuilder.aContractInput(null).withType(null).withDescription(null).build()).build();
        byte[] serializedContract = new ObjectMapper().writeValueAsBytes((Object)anEmptyContract);
        ContractDeserializer contractDeserializer = new ContractDeserializer();
        Contract contract = contractDeserializer.deserialize(new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(serializedContract), null);
        Assertions.assertThat((List)contract.getInput()).extracting(new String[]{"name", "type", "description", "mandatory", "multiple", "input"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"", String.class.getName(), null, false, false, Lists.newArrayList()})});
    }
}

