/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.contract.builders;

import java.time.LocalDate;
import java.util.List;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;

public class ContractBuilder {
    private Contract contract;
    private EditMode editMode = EditMode.CREATE;

    private ContractBuilder(Contract contract) {
        this.contract = contract;
    }

    public static ContractBuilder aContract() {
        return new ContractBuilder(new Contract());
    }

    public ContractBuilder withInput(ContractInput ... contractInput) {
        for (ContractInput input : contractInput) {
            this.contract.addInput(input);
        }
        return this;
    }

    public ContractBuilder inEditMode() {
        this.editMode = EditMode.EDIT;
        return this;
    }

    public Contract build() {
        this.updateEditMode(this.contract.getInput());
        return this.contract;
    }

    private void updateEditMode(List<ContractInput> input) {
        input.stream().forEach(in -> {
            in.setMode(this.editMode);
            this.updateEditMode(in.getInput());
        });
    }

    public static Contract aSimpleContract() {
        return ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aContractInput("name").withDescription("employee name").build(), ContractInputBuilder.aBooleanContractInput("isValid"), ContractInputBuilder.aNodeContractInput("ticket").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput("title"), ContractInputBuilder.aDateContractInput("creationDate"), ContractInputBuilder.aLocalDateContractInput("creationLocalDate"), ContractInputBuilder.aLocalDateTimeContractInput("creationLocalDateTime"), ContractInputBuilder.aOffsetDateTimeContractInput("creationOffsetDateTime"), ContractInputBuilder.aLongContractInput("updateTime")}).build()}).build();
    }

    public static Contract aSimpleContractWithDataRef(EditMode mode) {
        ContractBuilder contractBuilder = ContractBuilder.aContract();
        if (mode == EditMode.EDIT) {
            contractBuilder = contractBuilder.inEditMode();
        }
        return contractBuilder.withInput(ContractInputBuilder.aNodeContractInput("employeeInput").withDataReference(new BusinessDataReference("employee", "org.test.Employee", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(ContractInputBuilder.aContractInput("firstName").build(), ContractInputBuilder.aContractInput("lastName").build(), ContractInputBuilder.aContractInput("birthDate").withType(LocalDate.class.getName()).build(), ContractInputBuilder.aNodeContractInput("manager").withDataReference(new BusinessDataReference("manager", "org.test.Employee", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.LAZY)).withInput(ContractInputBuilder.aContractInput("firstName").build(), ContractInputBuilder.aNodeContractInput("addresses").mulitple().withDataReference(new BusinessDataReference("addresses", "org.test.Address", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.LAZY)).build()).build(), ContractInputBuilder.aNodeContractInput("addresses").withDataReference(new BusinessDataReference("addresses", "org.test.Address", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.LAZY)).mulitple().withInput(ContractInputBuilder.aContractInput("street").build(), ContractInputBuilder.aContractInput("zipcode").build(), ContractInputBuilder.aContractInput("city").build(), ContractInputBuilder.aNodeContractInput("country").withDataReference(new BusinessDataReference("country", "org.test.Country", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.LAZY)).build()).build()).build()).build();
    }

    public static Contract aContractWithDataRefAndAggregation(EditMode mode) {
        ContractBuilder contractBuilder = ContractBuilder.aContract();
        if (mode == EditMode.EDIT) {
            contractBuilder = contractBuilder.inEditMode();
        }
        return contractBuilder.withInput(ContractInputBuilder.aNodeContractInput("employeeInput").withDataReference(new BusinessDataReference("employee", "org.test.Employee", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(ContractInputBuilder.aContractInput("firstName").build(), ContractInputBuilder.aContractInput("lastName").build(), ContractInputBuilder.aContractInput("birthDate").withType(LocalDate.class.getName()).build(), ContractInputBuilder.aNodeContractInput("manager").withDataReference(new BusinessDataReference("manager", "org.test.Employee", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER)).withInput(ContractInputBuilder.aContractInput("persistenceId_string").build()).build(), ContractInputBuilder.aNodeContractInput("addresses").withDataReference(new BusinessDataReference("addresses", "org.test.Address", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.LAZY)).mulitple().withInput(ContractInputBuilder.aContractInput("persistenceId_string").build(), ContractInputBuilder.aContractInput("street").build(), ContractInputBuilder.aContractInput("zipcode").build(), ContractInputBuilder.aContractInput("city").build()).build()).build()).build();
    }

    public static Contract aContractWithMultipleInput() {
        return ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aMultipleStringContractInput("names")}).build();
    }
}

