/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.contract.builders;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.DataReference;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.NodeContractInput;

public class ContractInputBuilder {
    private ContractInput contractInput;

    public ContractInputBuilder(ContractInput contractInput) {
        this.contractInput = contractInput;
    }

    public ContractInputBuilder withType(String classname) {
        this.contractInput.setType(classname);
        return this;
    }

    public ContractInputBuilder withDescription(String description) {
        this.contractInput.setDescription(description);
        return this;
    }

    public ContractInputBuilder mulitple() {
        this.contractInput.setMultiple(true);
        return this;
    }

    public ContractInputBuilder simple() {
        this.contractInput.setMultiple(false);
        return this;
    }

    public ContractInputBuilder mandatory() {
        this.contractInput.setMandatory(true);
        return this;
    }

    public ContractInputBuilder optional() {
        this.contractInput.setMandatory(false);
        return this;
    }

    public ContractInputBuilder withDataReference(BusinessDataReference dataReference) {
        if (this.contractInput instanceof NodeContractInput) {
            ((NodeContractInput)this.contractInput).setDataReference((DataReference)dataReference);
        }
        return this;
    }

    public ContractInputBuilder withInput(ContractInput ... contractInputs) {
        for (ContractInput input : contractInputs) {
            this.contractInput.addInput(input);
        }
        return this;
    }

    public ContractInput build() {
        return this.contractInput;
    }

    public static ContractInputBuilder aContractInput(String name) {
        return new ContractInputBuilder((ContractInput)new LeafContractInput(name, String.class));
    }

    public static LeafContractInput aBooleanContractInput(String name) {
        return new LeafContractInput(name, Boolean.class);
    }

    public static LeafContractInput aStringContractInput(String name) {
        return new LeafContractInput(name, String.class);
    }

    public static LeafContractInput aReadOnlyStringContractInput(String name) {
        LeafContractInput leafContractInput = new LeafContractInput(name, String.class);
        leafContractInput.setReadonly(true);
        return leafContractInput;
    }

    public static LeafContractInput aMultipleStringContractInput(String name) {
        LeafContractInput input = new LeafContractInput(name, String.class);
        input.setMultiple(true);
        return input;
    }

    public static LeafContractInput aLongContractInput(String name) {
        return new LeafContractInput(name, Long.class);
    }

    public static LeafContractInput anIntegerContractInput(String name) {
        return new LeafContractInput(name, Integer.class);
    }

    @Deprecated
    public static LeafContractInput aDateContractInput(String name) {
        return new LeafContractInput(name, Date.class);
    }

    public static LeafContractInput aLocalDateContractInput(String name) {
        return new LeafContractInput(name, LocalDate.class);
    }

    public static LeafContractInput aLocalDateTimeContractInput(String name) {
        return new LeafContractInput(name, LocalDateTime.class);
    }

    public static LeafContractInput aOffsetDateTimeContractInput(String name) {
        return new LeafContractInput(name, OffsetDateTime.class);
    }

    public static LeafContractInput aFileContractInput(String name) {
        return new LeafContractInput(name, File.class);
    }

    public static ContractInputBuilder aNodeContractInput(String name) {
        return new ContractInputBuilder((ContractInput)new NodeContractInput(name));
    }
}

