/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.migrationReport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;

public class MigrationResult<T> {
    private T artifact;
    private List<MigrationStepReport> migrationStepReportList = new ArrayList<MigrationStepReport>();

    public MigrationResult(T artifact, List<MigrationStepReport> migrationStepReportList) {
        this.artifact = artifact;
        this.migrationStepReportList = migrationStepReportList;
    }

    public List<MigrationStepReport> getMigrationStepReportList() {
        return this.migrationStepReportList;
    }

    public void setMigrationStepReportList(List<MigrationStepReport> migrationStepReportList) {
        this.migrationStepReportList = migrationStepReportList;
    }

    public T getArtifact() {
        return this.artifact;
    }

    public void setArtifact(T artifact) {
        this.artifact = artifact;
    }

    public List<MigrationStepReport> getMigrationStepReportListFilterByFinalStatus() {
        return this.migrationStepReportList.stream().filter(stepReport -> this.getStatusList().contains((Object)stepReport.getMigrationStatus())).collect(Collectors.toList());
    }

    public MigrationStatus getFinalStatus() {
        return this.containsMigrationStatus(MigrationStatus.ERROR) ? MigrationStatus.ERROR : (this.containsMigrationStatus(MigrationStatus.WARNING) ? MigrationStatus.WARNING : MigrationStatus.SUCCESS);
    }

    private boolean containsMigrationStatus(MigrationStatus migrationStatus) {
        List list = this.migrationStepReportList.stream().filter(stepReport -> migrationStatus.getValue().equals(stepReport.getMigrationStatus().getValue())).collect(Collectors.toList());
        return list.size() > 0;
    }

    private List<MigrationStatus> getStatusList() {
        switch (this.getFinalStatus()) {
            case SUCCESS: {
                return Collections.emptyList();
            }
            case ERROR: 
            case WARNING: {
                return Arrays.asList(MigrationStatus.ERROR, MigrationStatus.WARNING);
            }
        }
        return Arrays.asList(MigrationStatus.SUCCESS, MigrationStatus.ERROR, MigrationStatus.WARNING, MigrationStatus.NONE);
    }
}

