/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.generator.mapping.dataManagement.BusinessObject;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.NodeBusinessObjectInput;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;

public class BusinessObjectBuilder {
    private NodeBusinessObjectInput rootNodeInput;
    private BusinessObject businessObject;

    private BusinessObjectBuilder(BusinessObject businessObject) {
        this.businessObject = businessObject;
    }

    public static BusinessObjectBuilder aBusinessObject() {
        return new BusinessObjectBuilder(new BusinessObject());
    }

    public BusinessObjectBuilder withInput(ContractInput ... contractInput) {
        for (ContractInput input : contractInput) {
            this.businessObject.addInput(input);
        }
        return this;
    }

    public BusinessObjectBuilder withNodeBusinessObjectInput(NodeBusinessObjectInput rootNodeInput) {
        this.rootNodeInput = rootNodeInput;
        return this;
    }

    public BusinessObjectBuilder withANodeBusinessObjectInput() {
        this.rootNodeInput = new NodeBusinessObjectInput("com.company.model.person", "person");
        return this;
    }

    public static ContractInputBuilder aBusinessObjectNodeInput(String name, String pageDataName) {
        return new ContractInputBuilder((ContractInput)new NodeBusinessObjectInput(name, pageDataName));
    }

    public static BusinessObject aSimpleBusinessObject() {
        ContractInput a = BusinessObjectBuilder.aBusinessObjectNodeInput("com.company.model.ticket", "ticket").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"title"), ContractInputBuilder.aDateContractInput((String)"creationDate"), ContractInputBuilder.aLocalDateContractInput((String)"creationLocalDate"), ContractInputBuilder.aLocalDateTimeContractInput((String)"creationLocalDateTime"), ContractInputBuilder.aOffsetDateTimeContractInput((String)"creationOffsetDateTime"), ContractInputBuilder.aLongContractInput((String)"updateTime")}).build();
        ContractInput b = BusinessObjectBuilder.aBusinessObjectNodeInput("com.company.model.person", "person").withInput(new ContractInput[]{ContractInputBuilder.aContractInput((String)"name").withDescription("employee name").build(), ContractInputBuilder.aBooleanContractInput((String)"isValid"), a}).build();
        return BusinessObjectBuilder.aBusinessObject().withInput(b).build();
    }

    public BusinessObject build() {
        return this.businessObject;
    }
}

