/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.bonitasoft.web.designer.controller.PreviewController;
import org.bonitasoft.web.designer.controller.preview.Previewer;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(value=MockitoJUnitRunner.class)
public class PreviewControllerTest {
    private MockMvc mockMvc;
    @Mock
    private Previewer previewer;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    private Path widgetRepositoryPath;
    private Path pageRepositoryPath;
    private Path fragmentRepositoryPath;
    private Path tmpWorkspacePath;
    @Mock
    private WorkspacePathResolver pathResolver;

    @Before
    public void beforeEach() throws Exception {
        this.widgetRepositoryPath = Paths.get(this.getClass().getResource("/workspace/widgets").toURI());
        this.pageRepositoryPath = Paths.get(this.getClass().getResource("/workspace/pages").toURI());
        this.fragmentRepositoryPath = Paths.get(this.getClass().getResource("/workspace/fragments").toURI());
        this.tmpWorkspacePath = Paths.get(this.getClass().getResource("/tmpWorkspace/pages").toURI());
        this.mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{new PreviewController(this.pageRepository, this.fragmentRepository, this.previewer, this.widgetRepositoryPath, this.fragmentRepositoryPath, this.pageRepositoryPath, this.pathResolver)}).build();
    }

    @Test
    public void should_call_the_previewer() throws Exception {
        ResponseEntity response = new ResponseEntity((Object)"Everything ok", HttpStatus.OK);
        Mockito.when((Object)this.previewer.render((String)Matchers.eq((Object)"my-page"), (Repository)Matchers.eq((Object)this.pageRepository), (HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)response);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/my-page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Everything ok")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_load_page_asset_on_disk() throws Exception {
        Path expectedFile = this.pageRepositoryPath.resolve("ma-page/assets/js/timeshift.js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/ma-page/assets/js/timeshift.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"timeshift.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_respond_404_when_page_asset_is_not_found() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"preview/page/no-app-selected/ma-page/assets/js/unkknown.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_404_when_widget_asset_is_not_found() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/widget/no-app-selected/widget-id/assets/widget-id/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_load_widget_asset_included_in_page_on_disk() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/assets/css/my-css-1.0.0.css");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/page-id/widgets/pbLabel/assets/css/my-css-1.0.0.css", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"my-css-1.0.0.css\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_load_widget_asset_included_in_any_previewable_on_disk() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/assets/css/my-css-1.0.0.css");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/aPreviewable/no-app-selected/previewable-id/widgets/pbLabel/assets/css/my-css-1.0.0.css", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"my-css-1.0.0.css\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_load_widget_directive() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/pbLabel.js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/page-id/widgets/pbLabel/pbLabel.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"pbLabel.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_load_widget_directive_for_any_previewable() throws Exception {
        Path expectedFile = this.widgetRepositoryPath.resolve("pbLabel/pbLabel.js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/aPreviewable/no-app-selected/previewable-id/widgets/pbLabel/pbLabel.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"pbLabel.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_respond_404_when_widget_asset_included_in_page_is_not_found() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/page-id/widgets/widget-id/assets/js/asset.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_return_a_fake_css_file_for_living_application_theme() throws Exception {
        String expectedContent = "/**" + System.lineSeparator() + "* Living application theme" + System.lineSeparator() + "*/";
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/theme/theme.css", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(expectedContent)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"theme.css\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_redirect_page_theme_calls_to_the_real_theme_resource() throws Exception {
        String expectedContent = "/**" + System.lineSeparator() + "* Living application theme" + System.lineSeparator() + "*/";
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/myApp/theme/images/logo.png", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.redirectedUrl((String)"/apps/myApp/theme/images/logo.png"));
    }

    @Test
    public void should_redirect_page_API_calls_to_the_real_API() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/API/portal/page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.redirectedUrl((String)"/API/portal/page"));
    }

    @Test
    public void should_redirect_layout_API_calls_to_the_real_API() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/layout/no-app-selected/API/portal/page", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.redirectedUrl((String)"/API/portal/page"));
    }

    @Test
    public void should_redirect_API_calls_to_the_real_API_and_add_the_query_string() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/API/portal/page?p=0&c=1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.redirectedUrl((String)"/API/portal/page?p=0&c=1"));
    }

    @Test
    public void should_temporarily_redirect_API_post_to_the_real_API() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/preview/page/no-app-selected/API/portal/page?id=123", (Object[])new Object[0])).andExpect(new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                Assert.assertEquals((int)result.getResponse().getStatus(), (int)307);
                Assert.assertEquals((String)result.getResponse().getRedirectedUrl(), (String)"/API/portal/page?id=123");
            }
        });
    }

    @Test
    public void should_load_widget_minify_files_for_any_previawable() throws Exception {
        Mockito.when((Object)this.pathResolver.getTmpPagesRepositoryPath()).thenReturn((Object)this.tmpWorkspacePath);
        Path expectedFile = this.tmpWorkspacePath.resolve("ma-page/js/widgets-abc123.min.js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/ma-page/js/widgets-abc123.min.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"widgets-abc123.min.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_call_the_previewer_for_fragments() throws Exception {
        ResponseEntity response = new ResponseEntity((Object)"Everything ok", HttpStatus.OK);
        Mockito.when((Object)this.previewer.render((String)Matchers.eq((Object)"my-fragment"), (Repository)Matchers.eq((Object)this.fragmentRepository), (HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)response);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/fragment/no-app-selected/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Everything ok")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_load_fragment_directive() throws Exception {
        Path expectedFile = this.fragmentRepositoryPath.resolve("person/person.js");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/a-page/fragments/person/person.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(Files.readAllBytes(expectedFile))).andExpect(MockMvcResultMatchers.header().string("Content-Length", String.valueOf(expectedFile.toFile().length()))).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "inline; filename=\"person.js\"")).andExpect(MockMvcResultMatchers.content().encoding("UTF-8"));
    }

    @Test
    public void should_respond_404_not_found_when_fragment_directive_is_not_found() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/preview/page/no-app-selected/a-page/fragments/unknown/unkwnon.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

