/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.importer.ArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportStoreTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Mock
    private ArtifactImporter artifactImporter;
    private ImportStore importStore;

    @Before
    public void setUp() throws Exception {
        this.importStore = new ImportStore();
    }

    @Test
    public void should_store_import() throws Exception {
        Path importPath = Paths.get("import/path", new String[0]);
        Import storedImport = this.importStore.store(this.artifactImporter, importPath);
        Assertions.assertThat((String)storedImport.getUUID()).isNotNull();
        Assertions.assertThat((Object)storedImport.getImporter()).isEqualTo((Object)this.artifactImporter);
        Assertions.assertThat((Path)storedImport.getPath()).isEqualTo((Object)importPath);
    }

    @Test
    public void should_get_a_stored_import() throws Exception {
        Import expectedImport = this.importStore.store(this.artifactImporter, Paths.get("import/path", new String[0]));
        Import fetchedImport = this.importStore.get(expectedImport.getUUID());
        Assertions.assertThat((Object)expectedImport).isEqualTo((Object)fetchedImport);
    }

    @Test(expected=NotFoundException.class)
    public void should_throw_not_found_exception_while_getting_an_unknown_import() throws Exception {
        this.importStore.get("unknown-import");
    }

    @Test(expected=NotFoundException.class)
    public void should_remove_a_stored_import() throws Exception {
        Import addedReport = this.importStore.store(this.artifactImporter, Paths.get("import/path", new String[0]));
        this.importStore.remove(addedReport.getUUID());
        this.importStore.get(addedReport.getUUID());
    }

    @Test
    public void should_delete_folder_while_removing_a_stored_import() throws Exception {
        Path importFolder = this.temporaryFolder.newFolderPath("importFolder");
        Import addedReport = this.importStore.store(this.artifactImporter, importFolder);
        this.importStore.remove(addedReport.getUUID());
        Assertions.assertThat((Path)importFolder).doesNotExist();
    }

    @Test
    public void should_fail_silently_while_removing_an_unexisting_import() throws Exception {
        this.importStore.remove("unexinting id");
    }
}

