/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.utils.Unzipper;
import org.junit.Before;
import org.junit.Test;

public class UnzipperTest {
    private Unzipper unzipper;

    @Before
    public void setUp() throws IOException {
        this.unzipper = new Unzipper();
    }

    @Test(expected=ZipException.class)
    public void should_throw_zip_exception_when_inpustream_cannot_be_unzipped() throws Exception {
        InputStream stream = UnzipperTest.class.getResourceAsStream("notAzipFile.txt");
        Path unzipInTempDir = this.unzipper.unzipInTempDir(stream, "aPrefix");
        FileUtils.deleteDirectory((File)unzipInTempDir.toFile());
    }

    @Test
    public void should_unzip_a_zip_file_into_a_temp_folder() throws Exception {
        InputStream stream = UnzipperTest.class.getResourceAsStream("azipFile.zip");
        Path unzipInTempDir = this.unzipper.unzipInTempDir(stream, "aPrefix");
        Assertions.assertThat((File)unzipInTempDir.resolve("notAzipFile.txt").toFile()).exists();
        FileUtils.deleteDirectory((File)unzipInTempDir.toFile());
    }
}

