/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping.data;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.mapping.data.BusinessQueryData;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.data.Data;
import org.bonitasoft.web.designer.model.data.DataType;
import org.junit.Test;

public class BusinessQueryDataTest {
    @Test
    public void should_add_external_api_variable_on_page_when_contract_contains_an_aggregated_data_ref() throws Exception {
        BusinessQueryData queryData = new BusinessQueryData(new BusinessDataReference("manager", "com.company.model.EmployeeObject", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER));
        Data data = queryData.create();
        Assertions.assertThat((String)queryData.name()).isEqualTo((Object)"employeeObject_query");
        Assertions.assertThat((Comparable)data.getType()).isEqualTo((Object)DataType.URL);
        Assertions.assertThat((Object)data.getValue()).isEqualTo((Object)"../API/bdm/businessData/com.company.model.EmployeeObject?q=find&p=0&c=99");
    }

    @Test
    public void should_BusinessQueryData_with_the_same_name_be_equal() throws Exception {
        BusinessQueryData queryData = new BusinessQueryData(new BusinessDataReference("manager", "com.company.model.EmployeeObject", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER));
        BusinessQueryData queryData2 = new BusinessQueryData(new BusinessDataReference("deleguee", "com.company.model.EmployeeObject", BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER));
        Assertions.assertThat((Object)queryData).isEqualTo((Object)queryData2);
    }
}

