/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.parametrizedWidget;

import java.time.LocalDate;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.assertions.AbstractParametrizedWidgetAssert;
import org.bonitasoft.web.designer.generator.assertions.ButtonWidgetAssert;
import org.bonitasoft.web.designer.generator.assertions.DatePickerWidgetAssert;
import org.bonitasoft.web.designer.generator.assertions.DateTimePickerWidgetAssert;
import org.bonitasoft.web.designer.generator.assertions.InputWidgetAssert;
import org.bonitasoft.web.designer.generator.assertions.TitleWidgetAssert;
import org.bonitasoft.web.designer.generator.parametrizedWidget.AbstractParametrizedWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.Alignment;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ButtonAction;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ButtonStyle;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ButtonWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.CheckboxWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.DatePickerWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.DateTimePickerWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.FileUploadWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.InputType;
import org.bonitasoft.web.designer.generator.parametrizedWidget.InputWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.LabelPosition;
import org.bonitasoft.web.designer.generator.parametrizedWidget.LinkWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParameterConstants;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParametrizedWidgetFactory;
import org.bonitasoft.web.designer.generator.parametrizedWidget.SelectWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.TextWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.TitleWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.WidgetContainer;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.DataReference;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.NodeContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class ParametrizedWidgetFactoryTest
implements ParameterConstants {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void create_an_input_widget_for_string_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aStringContractInput((String)"name"));
        Assertions.assertThat((Object)component).isInstanceOf(InputWidget.class);
    }

    @Test
    public void create_a_text_input_for_string_contract_input_with_a_display_label() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        InputWidget component = (InputWidget)elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aStringContractInput((String)"name"));
        InputWidgetAssert.assertThat(component).hasLabelPosition(LabelPosition.TOP.getValue()).hasLabelWidth(1).hasType(InputType.TEXT.getValue());
        AbstractParametrizedWidgetAssert.assertThat((AbstractParametrizedWidget)component).isDisplayed().hasLabel("Name").isNotLabelHidden();
        Assertions.assertThat((boolean)component.isReadOnly()).isFalse();
    }

    @Test
    public void create_a_datepicker_for_localdate_contract_input_with_description_keeping_default_placeholder() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        LeafContractInput contractInput = ContractInputBuilder.aLocalDateContractInput((String)"name");
        contractInput.setDescription("My description");
        InputWidget component = (InputWidget)elementFactory.createParametrizedWidget((ContractInput)contractInput);
        InputWidgetAssert.assertThat(component).hasPlaceholder("Enter a date (mm/dd/yyyy)");
    }

    @Test
    public void create_a_text_input_for_string_contract_input_with_full_with() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aStringContractInput((String)"name"));
        Assertions.assertThat((Integer)component.getDimension()).isEqualTo(12);
    }

    @Test
    public void create_an_input_widget_for_numeric_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aLongContractInput((String)"name"));
        Assertions.assertThat((Object)component).isInstanceOf(InputWidget.class);
    }

    @Deprecated
    @Test
    public void create_a_datepicker_for_date_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aDateContractInput((String)"creationDate"));
        Assertions.assertThat((Object)component).isInstanceOf(DatePickerWidget.class);
    }

    @Test
    public void create_a_datepicker_for_local_date_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aLocalDateContractInput((String)"creationLocalDate"));
        Assertions.assertThat((Object)component).isInstanceOf(DatePickerWidget.class);
    }

    @Test
    public void create_a_datetimepicker_for_local_date_time_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aLocalDateTimeContractInput((String)"creationLocalDateTime"));
        Assertions.assertThat((Object)component).isInstanceOf(DateTimePickerWidget.class);
    }

    @Test
    public void create_a_checkbox_for_boolean_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)new LeafContractInput("isValidated", Boolean.class));
        Assertions.assertThat((Object)component).isInstanceOf(CheckboxWidget.class);
        Assertions.assertThat((String)((CheckboxWidget)component).getLabel()).isEqualTo((Object)"Is Validated");
    }

    @Test
    public void create_a_file_upload_for_file_contract_input_with_a_default_url() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        AbstractParametrizedWidget component = elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aFileContractInput((String)"document"));
        Assertions.assertThat((Object)component).isInstanceOf(FileUploadWidget.class);
        Assertions.assertThat((String)((FileUploadWidget)component).getLabel()).isEqualTo((Object)"Document");
        Assertions.assertThat((String)((FileUploadWidget)component).getUrl()).isEqualTo((Object)"../API/formFileUpload");
    }

    @Test
    public void should_create_a_datepicker_for_date_contract_input_with_date_format() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        DatePickerWidget component = (DatePickerWidget)elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aDateContractInput((String)"creationDate"));
        DatePickerWidgetAssert.assertThat(component).hasPlaceholder();
        DatePickerWidgetAssert.assertThat(component).hasDateFormat("MM/dd/yyyy");
    }

    @Test
    public void should_create_a_datepicker_for_date_contract_input_with_local_date_format() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        DatePickerWidget component = (DatePickerWidget)elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aLocalDateContractInput((String)"creationLocalDate"));
        DatePickerWidgetAssert.assertThat(component).hasPlaceholder();
        DatePickerWidgetAssert.assertThat(component).hasDateFormat("MM/dd/yyyy");
    }

    @Test
    public void should_create_a_datetimepicker_for_date_contract_input_with_local_date_time_format() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        DateTimePickerWidget component = (DateTimePickerWidget)elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aLocalDateTimeContractInput((String)"creationLocalDateTime"));
        DateTimePickerWidgetAssert.assertThat(component).hasDateFormat("MM/dd/yyyy");
        DateTimePickerWidgetAssert.assertThat(component).hasTimeFormat("h:mm:ss a");
        DateTimePickerWidgetAssert.assertThat(component).hasDatePlaceholder();
        DateTimePickerWidgetAssert.assertThat(component).hasTimePlaceholder();
        Assertions.assertThat((boolean)component.isWithTimeZone()).isEqualTo(false);
    }

    @Test
    public void should_create_a_datetimepicker_for_date_contract_input_with_off_date_time_format() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        DateTimePickerWidget component = (DateTimePickerWidget)elementFactory.createParametrizedWidget((ContractInput)ContractInputBuilder.aOffsetDateTimeContractInput((String)"creationOffSetDateTime"));
        Assertions.assertThat((boolean)component.isWithTimeZone()).isEqualTo(true);
        DateTimePickerWidgetAssert.assertThat(component).hasDateFormat("MM/dd/yyyy");
        DateTimePickerWidgetAssert.assertThat(component).hasTimeFormat("h:mm:ss a");
        DateTimePickerWidgetAssert.assertThat(component).hasDatePlaceholder();
        DateTimePickerWidgetAssert.assertThat(component).hasTimePlaceholder();
    }

    @Test
    public void throw_a_IllegalArgumentException_for_unsupported_input_type() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        this.thrown.expect(IllegalArgumentException.class);
        elementFactory.createParametrizedWidget((ContractInput)new LeafContractInput("unsupported", IllegalArgumentException.class));
    }

    @Test
    public void create_a_label_component_with_contract_input_name_as_display_label() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        TitleWidget component = elementFactory.createTitle((ContractInput)ContractInputBuilder.aStringContractInput((String)"isValid"));
        TitleWidgetAssert.assertThat(component).hasText("Is Valid");
        Assertions.assertThat((String)component.getAlignment()).isEqualTo((Object)Alignment.LEFT.getValue());
        AbstractParametrizedWidgetAssert.assertThat((AbstractParametrizedWidget)component).isDisplayed();
    }

    @Test
    public void create_a_label_component_with_contract_input_with_full_with() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        TitleWidget component = elementFactory.createTitle((ContractInput)ContractInputBuilder.aStringContractInput((String)"isValid"));
        Assertions.assertThat((Integer)component.getDimension()).isEqualTo(12);
    }

    @Test
    public void create_a_container_with_full_size() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ContractInput input = (ContractInput)Mockito.mock(ContractInput.class);
        Mockito.when((Object)input.isMultiple()).thenReturn((Object)false);
        WidgetContainer container = elementFactory.createWidgetContainer(input);
        Assertions.assertThat((Integer)container.getDimension()).isEqualTo(12);
    }

    @Test
    public void create_a_displayed_container() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ContractInput input = (ContractInput)Mockito.mock(ContractInput.class);
        Mockito.when((Object)input.isMultiple()).thenReturn((Object)false);
        WidgetContainer container = elementFactory.createWidgetContainer(input);
        AbstractParametrizedWidgetAssert.assertThat((AbstractParametrizedWidget)container).isDisplayed();
    }

    @Test
    public void create_submit_button_with_submit_task_action_for_a_contract() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ButtonWidget button = elementFactory.createSubmitButton(ButtonAction.SUBMIT_TASK);
        ButtonWidgetAssert.assertThat(button).hasAction(ButtonAction.SUBMIT_TASK.getValue());
    }

    @Test
    public void create_submit_button_with_start_process_action_for_a_contract() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ButtonWidget button = elementFactory.createSubmitButton(ButtonAction.START_PROCESS);
        ButtonWidgetAssert.assertThat(button).hasAction(ButtonAction.START_PROCESS.getValue());
    }

    @Test
    public void create_submit_button_with_submit_label() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ButtonWidget button = elementFactory.createSubmitButton(ButtonAction.START_PROCESS);
        ButtonWidgetAssert.assertThat(button).hasButtonStyle(ButtonStyle.PRIMARY.getValue()).isNotDisabled();
        Assertions.assertThat((String)button.getAlignment()).isEqualTo((Object)Alignment.CENTER.getValue());
        AbstractParametrizedWidgetAssert.assertThat((AbstractParametrizedWidget)button).hasLabel("Submit").isDisplayed();
    }

    @Test
    public void text_contract_input_is_supported() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.aStringContractInput((String)"name"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void integer_contract_input_is_supported() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.anIntegerContractInput((String)"age"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void should_be_supported_date_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.aLocalDateContractInput((String)"creationDate"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void should_be_supported_local_date_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.aLocalDateContractInput((String)"creationLocalDate"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void should_be_supported_local_date_time_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.aLocalDateTimeContractInput((String)"creationLocalDateTime"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void should_be_supported_local_offset_date_time_contract_input() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.aLocalDateTimeContractInput((String)"creationOffsetDateTime"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void file_contract_input_is_supported() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        boolean isSupported = elementFactory.isSupported((ContractInput)ContractInputBuilder.aFileContractInput((String)"document"));
        Assertions.assertThat((boolean)isSupported).isTrue();
    }

    @Test
    public void create_add_button() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ContractInput input = (ContractInput)Mockito.mock(ContractInput.class);
        Mockito.when((Object)input.getName()).thenReturn((Object)"input");
        ButtonWidget button = elementFactory.createAddButton(input);
        Assertions.assertThat((Integer)button.getDimension()).isEqualTo(12);
        ButtonWidgetAssert.assertThat(button).hasButtonStyle(ButtonStyle.PRIMARY.getValue()).isNotDisabled();
        ButtonWidgetAssert.assertThat(button).hasAction(ButtonAction.ADD_TO_COLLECTION.getValue());
        Assertions.assertThat((String)button.getAlignment()).isEqualTo((Object)Alignment.LEFT.getValue());
        AbstractParametrizedWidgetAssert.assertThat((AbstractParametrizedWidget)button).hasLabel("<span class=\"glyphicon glyphicon-plus\"></span>").isDisplayed();
    }

    @Test
    public void create_remove_button() throws Exception {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        ButtonWidget button = elementFactory.createRemoveButton();
        Assertions.assertThat((Integer)button.getDimension()).isEqualTo(12);
        Assertions.assertThat((String)button.getCollectionPosition()).isEqualTo((Object)"Item");
        Assertions.assertThat((String)button.getRemoveItem()).isEqualTo((Object)"$item");
        Assertions.assertThat((String)button.getCollectionToModify()).isEqualTo((Object)"$collection");
        Assertions.assertThat((String)button.getAlignment()).isEqualTo((Object)Alignment.RIGHT.getValue());
        ButtonWidgetAssert.assertThat(button).hasButtonStyle(ButtonStyle.DANGER.getValue()).isNotDisabled();
        AbstractParametrizedWidgetAssert.assertThat((AbstractParametrizedWidget)button).hasLabel("<span class=\"glyphicon glyphicon-remove\"></span>").isDisplayed();
        ButtonWidgetAssert.assertThat(button).hasAction(ButtonAction.REMOVE_FROM_COLLECTION.getValue());
        PropertyValue PropertyValue2 = (PropertyValue)button.toPropertyValues().get("removeItem");
        Assertions.assertThat((String)PropertyValue2.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)PropertyValue2.getValue()).isEqualTo((Object)"$item");
    }

    @Test
    public void should_create_link_widget() {
        ParametrizedWidgetFactory elementFactory = this.createFactory();
        String linkText = "linkText";
        String linkUrl = "linkUrk";
        ButtonStyle linkStyle = ButtonStyle.LINK;
        LinkWidget link = elementFactory.createLink(linkText, linkUrl, linkStyle);
        Assertions.assertThat((String)link.getText()).isEqualTo((Object)linkText);
        Assertions.assertThat((String)link.getTargetUrl()).isEqualTo((Object)linkUrl);
        Assertions.assertThat((String)link.getButtonStyle()).isEqualTo((Object)linkStyle.getValue());
        Assertions.assertThat((Integer)link.getDimension()).isEqualTo(12);
        Assertions.assertThat((String)link.getAlignment()).isEqualTo((Object)Alignment.LEFT.getValue());
    }

    @Test
    public void should_create_read_only_widget_for_text_input() {
        DataReference dataReference = new DataReference("reference", String.class.getName());
        LeafContractInput input = new LeafContractInput("readOnlyText", String.class);
        input.setReadonly(true);
        input.setDataReference(dataReference);
        input.setMode(EditMode.EDIT);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(TextWidget.class);
        Assertions.assertThat((String)widget.getHidden()).isEqualTo((Object)"!reference");
        Assertions.assertThat((boolean)((TextWidget)widget).isLabelHidden()).isFalse();
        Assertions.assertThat((String)((TextWidget)widget).getLabel()).isEqualTo((Object)"Reference");
        Assertions.assertThat((String)((TextWidget)widget).getText()).isEqualTo((Object)"{{reference}}");
    }

    @Test
    public void should_create_read_only_widget_for_numeric_input() {
        DataReference dataReference = new DataReference("reference", Integer.class.getName());
        LeafContractInput input = new LeafContractInput("readOnlyInteger", Integer.class);
        input.setReadonly(true);
        input.setDataReference(dataReference);
        input.setMode(EditMode.EDIT);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(TextWidget.class);
        Assertions.assertThat((String)widget.getHidden()).isEqualTo((Object)"!reference");
        Assertions.assertThat((boolean)((TextWidget)widget).isLabelHidden()).isFalse();
        Assertions.assertThat((String)((TextWidget)widget).getLabel()).isEqualTo((Object)"Reference");
        Assertions.assertThat((String)((TextWidget)widget).getText()).isEqualTo((Object)"{{reference}}");
    }

    @Test
    public void should_create_read_only_widget_for_date_input() {
        DataReference dataReference = new DataReference("reference", LocalDate.class.getName());
        LeafContractInput input = new LeafContractInput("readOnlyDate", LocalDate.class);
        input.setReadonly(true);
        input.setDataReference(dataReference);
        input.setMode(EditMode.EDIT);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(TextWidget.class);
        Assertions.assertThat((String)widget.getHidden()).isEqualTo((Object)"!reference");
        Assertions.assertThat((boolean)((TextWidget)widget).isLabelHidden()).isFalse();
        Assertions.assertThat((String)((TextWidget)widget).getLabel()).isEqualTo((Object)"Reference");
        Assertions.assertThat((String)((TextWidget)widget).getText()).isEqualTo((Object)"{{reference|uiDate}}");
    }

    @Test
    public void should_create_read_only_widget_for_boolean_input() {
        DataReference dataReference = new DataReference("reference", Boolean.class.getName());
        LeafContractInput input = new LeafContractInput("readOnlyBoolean", Boolean.class);
        input.setReadonly(true);
        input.setDataReference(dataReference);
        input.setMode(EditMode.EDIT);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(CheckboxWidget.class);
        Assertions.assertThat((String)widget.getHidden()).isEqualTo((Object)"!reference");
        Assertions.assertThat((boolean)((CheckboxWidget)widget).isLabelHidden()).isFalse();
        Assertions.assertThat((String)((CheckboxWidget)widget).getLabel()).isEqualTo((Object)"Reference");
        Assertions.assertThat((boolean)((CheckboxWidget)widget).isDisabled()).isTrue();
        Assertions.assertThat((String)((CheckboxWidget)widget).getValue()).isEqualTo((Object)"reference");
    }

    @Test
    public void should_create_read_only_widget_for_aggregated_input() {
        BusinessDataReference dataReference = new BusinessDataReference("aggregatedReference", Object.class.getName(), BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER);
        NodeContractInput parent = new NodeContractInput("aggregatedObject");
        parent.setDataReference((DataReference)dataReference);
        parent.setMode(EditMode.EDIT);
        LeafContractInput input = new LeafContractInput("persistenceId_string", String.class);
        input.setReadonly(true);
        input.setMode(EditMode.EDIT);
        parent.addInput((ContractInput)input);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(TextWidget.class);
        Assertions.assertThat((String)widget.getHidden()).isEqualTo((Object)"!aggregatedReference");
        Assertions.assertThat((boolean)((TextWidget)widget).isLabelHidden()).isFalse();
        Assertions.assertThat((String)((TextWidget)widget).getLabel()).isEqualTo((Object)"Aggregated Reference");
        Assertions.assertThat((String)((TextWidget)widget).getText()).isEqualTo((Object)"{{aggregatedReference}}");
    }

    @Test
    public void should_create_combo_in_container_for_multiple_aggregated_attribute_with_multiple_parent() {
        BusinessDataReference rootReference = new BusinessDataReference("rootReference", Object.class.getName(), BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER);
        NodeContractInput root = new NodeContractInput("rootObject");
        root.setDataReference((DataReference)rootReference);
        root.setMode(EditMode.EDIT);
        root.setMultiple(true);
        BusinessDataReference parentReference = new BusinessDataReference("parentReference", Object.class.getName(), BusinessDataReference.RelationType.AGGREGATION, BusinessDataReference.LoadingType.EAGER);
        NodeContractInput parent = new NodeContractInput("aggregatedObject");
        parent.setMode(EditMode.EDIT);
        parent.setMultiple(true);
        parent.setDataReference((DataReference)parentReference);
        root.addInput((ContractInput)parent);
        LeafContractInput input = new LeafContractInput("persistenceId_string", String.class);
        input.setMode(EditMode.EDIT);
        parent.addInput((ContractInput)input);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(SelectWidget.class);
        SelectWidget selectWidget = (SelectWidget)widget;
        Assertions.assertThat((String)selectWidget.getAvailableValues()).isEqualTo((Object)"object_query");
        Assertions.assertThat((String)selectWidget.getValue()).isEqualTo((Object)"$item");
    }

    @Test
    public void should_set_required_false_for_non_mandatory_contract_input() {
        LeafContractInput aLocalDateContractInput = ContractInputBuilder.aLocalDateContractInput((String)"myDate");
        aLocalDateContractInput.setMandatory(false);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)aLocalDateContractInput);
        Assertions.assertThat((Object)widget).isInstanceOf(DatePickerWidget.class);
        Assertions.assertThat((boolean)((DatePickerWidget)widget).isRequired()).isFalse();
        aLocalDateContractInput.setMandatory(true);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aLocalDateContractInput);
        Assertions.assertThat((Object)widget).isInstanceOf(DatePickerWidget.class);
        Assertions.assertThat((boolean)((DatePickerWidget)widget).isRequired()).isTrue();
        LeafContractInput aLocalDateTimeContractInput = ContractInputBuilder.aLocalDateTimeContractInput((String)"myLocalDate");
        aLocalDateTimeContractInput.setMandatory(false);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aLocalDateTimeContractInput);
        Assertions.assertThat((Object)widget).isInstanceOf(DateTimePickerWidget.class);
        Assertions.assertThat((boolean)((DateTimePickerWidget)widget).isRequired()).isFalse();
        aLocalDateTimeContractInput.setMandatory(true);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aLocalDateTimeContractInput);
        Assertions.assertThat((Object)widget).isInstanceOf(DateTimePickerWidget.class);
        Assertions.assertThat((boolean)((DateTimePickerWidget)widget).isRequired()).isTrue();
        LeafContractInput aInputWidget = ContractInputBuilder.aStringContractInput((String)"myString");
        aInputWidget.setMandatory(false);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aInputWidget);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isRequired()).isFalse();
        aInputWidget.setMandatory(true);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aInputWidget);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isRequired()).isTrue();
        aInputWidget.setMultiple(true);
        aInputWidget.setMandatory(false);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aInputWidget);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isRequired()).isTrue();
    }

    @Test
    public void should_create_file_upload_with_required_expression_for_multiple_document_in_edit_mode() {
        LeafContractInput documentsContractInput = ContractInputBuilder.aFileContractInput((String)"documents");
        documentsContractInput.setMultiple(true);
        documentsContractInput.setMode(EditMode.EDIT);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)documentsContractInput);
        Assertions.assertThat((Object)widget).isInstanceOf(FileUploadWidget.class);
        Assertions.assertThat((Optional)((FileUploadWidget)widget).getRequiredExpression()).isPresent();
        Assertions.assertThat((String)((String)((FileUploadWidget)widget).getRequiredExpression().get())).isEqualTo((Object)String.format("!%s.id", "$item"));
        documentsContractInput.setMode(EditMode.CREATE);
        widget = this.createFactory().createParametrizedWidget((ContractInput)documentsContractInput);
        Assertions.assertThat((Object)widget).isInstanceOf(FileUploadWidget.class);
        Assertions.assertThat((Optional)((FileUploadWidget)widget).getRequiredExpression()).isNotPresent();
    }

    private ParametrizedWidgetFactory createFactory() {
        return new ParametrizedWidgetFactory();
    }
}

