/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.i18n.LanguagePackBuilder;
import org.bonitasoft.web.designer.i18n.LanguagePackFactory;
import org.bonitasoft.web.designer.livebuild.PathListener;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.fedorahosted.tennera.jgettext.PoParser;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LanguagePackBuilderTest {
    @Mock
    Watcher watcher;
    LanguagePackBuilder builder;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.builder = new LanguagePackBuilder(this.watcher, new LanguagePackFactory(new PoParser(), new JacksonObjectMapper(new ObjectMapper())));
    }

    @Test
    public void should_build_all_language_pack_under_provided_directory() throws Exception {
        File frFile = this.folder.newFile("fr.po");
        this.folder.newFolder("i18n");
        File enFile = this.folder.newFile("i18n/en.po");
        Files.write(frFile.toPath(), this.aSimplePoFile(), new OpenOption[0]);
        Files.write(enFile.toPath(), this.aSimplePoFile(), new OpenOption[0]);
        this.builder.start(this.folder.getRoot().toPath());
        Assertions.assertThat((boolean)this.resolveJson(frFile).exists()).isTrue();
        Assertions.assertThat((boolean)this.resolveJson(enFile).exists()).isTrue();
    }

    @Test
    public void should_only_build_directives_files() throws Exception {
        Path path = this.folder.getRoot().toPath();
        this.builder.start(path);
        ((Watcher)Mockito.verify((Object)this.watcher)).watch((Path)Matchers.eq((Object)path), (PathListener)Matchers.any(PathListener.class));
    }

    @Test
    public void should_ignore_files_which_are_not_po_files() throws Exception {
        File poFile = this.folder.newFile("fr.po");
        this.folder.newFile("script.js");
        Files.write(poFile.toPath(), this.aSimplePoFile(), new OpenOption[0]);
        this.builder.start(this.folder.getRoot().toPath());
        Assertions.assertThat((Object[])this.folder.getRoot().list()).containsOnly((Object[])new String[]{"fr.po", "fr.json", "script.js"});
    }

    @Test
    public void should_replace_a_previous_build_with_new_one() throws Exception {
        File poFile = this.folder.newFile("file.po");
        File jsonFile = new File(poFile.getPath().replace(".po", ".json"));
        Files.write(poFile.toPath(), this.aSimplePoFile(), new OpenOption[0]);
        Files.write(jsonFile.toPath(), "previous content".getBytes(), new OpenOption[0]);
        this.builder.build(poFile.toPath());
        Assertions.assertThat((String)this.read(jsonFile)).isEqualTo((Object)"{\"francais\":{\"A page\":\"Une page\"}}");
    }

    private String read(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    public File resolveJson(File poFile) {
        return new File(poFile.getPath().replace(".po", ".json"));
    }

    private byte[] aSimplePoFile() throws Exception {
        return Files.readAllBytes(Paths.get(this.getClass().getResource("/i18n/simple.po").toURI()));
    }
}

