/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.migration.DataExposedMigrationStep;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataExposedMigrationStepTest {
    DataExposedMigrationStep dataExposedMigrationStep;

    @Before
    public void setUp() throws Exception {
        this.dataExposedMigrationStep = new DataExposedMigrationStep();
    }

    @Test
    public void should_migrate_fragment_when_data_is_exposed() throws Exception {
        Fragment fragment = FragmentBuilder.aFilledFragment("myFragment");
        Variable variable = new Variable(DataType.JSON, "{}");
        variable.setExposed(true);
        fragment.addVariable("myExposedVariable", variable);
        this.dataExposedMigrationStep.migrate(fragment);
        Assertions.assertThat((boolean)((Variable)fragment.getVariables().get("myExposedVariable")).isExposed()).isEqualTo(true);
        Assertions.assertThat((Comparable)((Variable)fragment.getVariables().get("myExposedVariable")).getType()).isEqualTo((Object)DataType.CONSTANT);
        Assertions.assertThat((List)((Variable)fragment.getVariables().get("myExposedVariable")).getValue()).isEqualTo(Arrays.asList(""));
    }

    @Test
    public void should_not_migrate_fragment_when_data_is_not_exposed() throws Exception {
        Fragment fragment = FragmentBuilder.aFilledFragment("myFragment");
        Variable variable = new Variable(DataType.JSON, "{}");
        variable.setExposed(false);
        fragment.addVariable("myNotExposedVariable", variable);
        this.dataExposedMigrationStep.migrate(fragment);
        Assertions.assertThat((boolean)((Variable)fragment.getVariables().get("myNotExposedVariable")).isExposed()).isEqualTo(false);
        Assertions.assertThat((Comparable)((Variable)fragment.getVariables().get("myNotExposedVariable")).getType()).isEqualTo((Object)DataType.JSON);
        Assertions.assertThat((List)((Variable)fragment.getVariables().get("myNotExposedVariable")).getValue()).isEqualTo(Arrays.asList("{}"));
    }
}

