/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.SimpleObject;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class JacksonObjectMapperTest {
    private JacksonObjectMapper objectMapper = new DesignerConfig().objectMapperWrapper();

    @Test
    public void should_deserialize_json() throws Exception {
        String json = "{\"name\": \"colin\", \"number\": 31}";
        SimpleObject object = (SimpleObject)this.objectMapper.fromJson(json.getBytes(StandardCharsets.UTF_8), SimpleObject.class);
        Assertions.assertThat((String)object.getName()).isEqualTo((Object)"colin");
        Assertions.assertThat((int)object.getNumber()).isEqualTo(31);
    }

    @Test
    public void should_serialize_object_into_json() throws Exception {
        SimpleObject object = new SimpleObject("id", "Vincent", 1);
        JSONAssert.assertEquals((String)new String(this.objectMapper.toJson((Object)object)), (String)"{\"name\":\"Vincent\",\"number\":1, \"another\": null, \"id\": \"id\"}", (boolean)false);
    }

    @Test
    public void should_deserialize_json_to_map() throws Exception {
        String json = "{\"name\": \"walter\", \"lastname\": \"bates\"}";
        Map map = this.objectMapper.fromJsonToMap(json.getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((String)((String)map.get("name"))).isEqualTo((Object)"walter");
        Assertions.assertThat((String)((String)map.get("lastname"))).isEqualTo((Object)"bates");
    }

    @Test
    public void should_serialize_map_into_json() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "walter");
        map.put("lastname", "bates");
        JSONAssert.assertEquals((String)new String(this.objectMapper.toJson(map)), (String)"{\"name\":\"walter\",\"lastname\":\"bates\"}", (boolean)false);
    }

    @Test
    public void should_serialize_object_into_json_using_serialization_view() throws Exception {
        SimpleObject object = new SimpleObject("id", "Vincent", 1);
        JSONAssert.assertEquals((String)new String(this.objectMapper.toJson((Object)object, JsonViewPersistence.class)), (String)"{\"name\":\"Vincent\",\"number\":1}", (boolean)false);
    }

    @Test
    public void should_serialize_object_into_human_readable_json_using_serialization_view() throws Exception {
        SimpleObject object = new SimpleObject("id", "Vincent", 1);
        Assertions.assertThat((String)new String(this.objectMapper.toPrettyJson((Object)object, JsonViewPersistence.class))).isEqualTo((Object)("{" + System.lineSeparator() + "  \"name\" : \"Vincent\"," + System.lineSeparator() + "  \"number\" : 1" + System.lineSeparator() + "}"));
    }

    @Test
    public void should_format_json_when_using_pretty_print_on_object() throws Exception {
        SimpleObject object = new SimpleObject("id", "Vincent", 1);
        Assertions.assertThat((String)this.objectMapper.prettyPrint((Object)object)).isEqualTo((Object)("{" + System.lineSeparator() + "  \"id\" : \"id\"," + System.lineSeparator() + "  \"name\" : \"Vincent\"," + System.lineSeparator() + "  \"number\" : 1," + System.lineSeparator() + "  \"another\" : null" + System.lineSeparator() + "}"));
    }

    @Test
    public void should_format_json_when_using_pretty_print_on_json() throws Exception {
        Assertions.assertThat((String)this.objectMapper.prettyPrint("{\"foo\":\"bar\"}")).isEqualTo((Object)("{" + System.lineSeparator() + "  \"foo\" : \"bar\"" + System.lineSeparator() + "}"));
    }

    @Test(expected=JsonProcessingException.class)
    public void should_check_that_json_is_invalid() throws Exception {
        String notjson = "\n    \"fr-FR\": {\n        \"Default name\": \"Nom par d\u00e9faut\",\n        \"Hello boys\": \"Coucou les gar\u00e7ooonns\"\n    },\n    \"ru-RU\": {\n        \"Default label\": \"Etiqueta por defecto\",\n        \"Hello boys\": \"Bonjourno los gar\u00e7ones\"\n    }\n}";
        this.objectMapper.checkValidJson(notjson.getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void should_check_that_json_is_valid() throws Exception {
        this.objectMapper.checkValidJson("{ \"collection\": [\n] }".getBytes(StandardCharsets.UTF_8));
        this.objectMapper.checkValidJson("[1, 2, 3, 4]".getBytes(StandardCharsets.UTF_8));
        String json = "{\n    \"fr-FR\": {\n        \"Default name\": \"Nom par d\u00e9faut\",\n        \"Hello boys\": \"Coucou les gar\u00e7ooonns\"\n    },\n    \"ru-RU\": {\n        \"Default label\": \"Etiqueta por defecto\",\n        \"Hello boys\": \"Bonjourno los gar\u00e7ones\"\n    }\n}";
        this.objectMapper.checkValidJson(json.getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void should_deserialize_json_with_password() throws Exception {
        String json = "{\"name\": \"colin\", \"number\": 31, \"password\": \"abcd\"}";
        SimpleObject object = (SimpleObject)this.objectMapper.fromJson(json.getBytes(StandardCharsets.UTF_8), SimpleObject.class);
        Assertions.assertThat((String)object.getName()).isEqualTo((Object)"colin");
        Assertions.assertThat((int)object.getNumber()).isEqualTo(31);
        Assertions.assertThat((String)object.getPassword()).isEqualTo((Object)"abcd");
    }

    @Test
    public void should_serialize_into_object_with_ignore_password() throws Exception {
        SimpleObject object = new SimpleObject("id", "Vincent", 1);
        object.setPassword("abcd");
        String expected = new String(this.objectMapper.toJson((Object)object));
        JSONAssert.assertEquals((String)expected, (String)"{\"name\":\"Vincent\",\"number\":1, \"another\": null, \"id\": \"id\"}", (boolean)false);
    }
}

