/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.studio.workspace;

import java.net.URI;
import org.bonitasoft.web.designer.studio.workspace.RestClient;
import org.bonitasoft.web.designer.studio.workspace.StudioHealthCheck;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class StudioHealthCheckTest {
    @Mock
    private RestClient restClient;
    @Mock
    private RestTemplate restTemplate;
    @Mock
    private ResponseEntity<String> successResponse;
    @Mock
    private ResponseEntity<String> errorResponse;
    private String statusURI = "http://localhost/api/workspace/status/";
    private StudioHealthCheck healthCheck;

    @Before
    public void prepareMocks() throws Exception {
        Mockito.when((Object)this.restClient.isConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.restClient.createURI("status/")).thenReturn((Object)this.statusURI);
        Mockito.when((Object)this.restClient.getRestTemplate()).thenReturn((Object)this.restTemplate);
        Mockito.when((Object)this.successResponse.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)this.errorResponse.getStatusCode()).thenReturn((Object)HttpStatus.NOT_FOUND);
        this.healthCheck = (StudioHealthCheck)Mockito.spy((Object)new StudioHealthCheck(this.restClient));
        ((StudioHealthCheck)Mockito.doNothing().when((Object)this.healthCheck)).exit();
    }

    @Test
    public void should_not_exit_when_studio_status_is_ok() throws Exception {
        Mockito.when((Object)this.restTemplate.getForEntity(URI.create(this.statusURI), String.class)).thenReturn(this.successResponse);
        this.healthCheck.run();
        ((StudioHealthCheck)Mockito.verify((Object)this.healthCheck, (VerificationMode)Mockito.never())).exit();
    }

    @Test
    public void should_exit_when_studio_status_is_ok() throws Exception {
        Mockito.when((Object)this.restTemplate.getForEntity(URI.create(this.statusURI), String.class)).thenReturn(this.errorResponse);
        this.healthCheck.run();
        ((StudioHealthCheck)Mockito.verify((Object)this.healthCheck)).exit();
    }
}

