/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Objects;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlAssert
extends AbstractAssert<HtmlAssert, Element> {
    private Objects objects = Objects.instance();

    protected HtmlAssert(Element actual) {
        super((Object)actual, HtmlAssert.class);
    }

    protected static Element toHead(String html) {
        return Jsoup.parse((String)html).head();
    }

    protected static Element toBody(String html) {
        return Jsoup.parse((String)html).body().child(0);
    }

    public HtmlAssert isEqualToBody(String html) {
        this.objects.assertEqual((AssertionInfo)this.info, (Object)this.normalize((Element)this.actual), (Object)this.normalize(HtmlAssert.toBody(html)));
        return this;
    }

    public HtmlAssert isEqualToHead(String html) {
        this.objects.assertEqual((AssertionInfo)this.info, (Object)this.normalize((Element)this.actual), (Object)this.normalize(HtmlAssert.toHead(html)));
        return this;
    }

    public HtmlAssert hasClass(String ... cssClasses) {
        for (String className : cssClasses) {
            if (((Element)this.actual).hasClass(className)) continue;
            this.failWithMessage("Expected element to has class [ %s ] but has [ %s ]", new Object[]{className, ((Element)this.actual).classNames()});
        }
        return this;
    }

    public HtmlAssert hasClassEqualTo(String cssClasse) {
        if (!((Element)this.actual).className().equals(cssClasse)) {
            this.failWithMessage("Expected class is [ %s ] but is [ %s ]", new Object[]{cssClasse, ((Element)this.actual).className()});
        }
        return this;
    }

    public HtmlAssert hasElement(String cssSelector) {
        Elements select = ((Element)this.actual).select(cssSelector);
        if (select.size() == 0) {
            this.failWithMessage("Expected html to have component %s but was not found", new Object[]{cssSelector});
        }
        return this;
    }

    public HtmlAssert element(String cssSelector) {
        return new HtmlAssert(((Element)this.actual).select(cssSelector).first());
    }

    public HtmlAssert hasAttributeValue(String attributeName, String attributeValue) {
        String attr = ((Element)this.actual).attr(attributeName);
        if (attr == null) {
            this.failWithMessage("Expected to have attribute [ %s ] but wasn't found", new Object[]{attributeName});
        } else if (!attr.equals(attributeValue)) {
            this.failWithMessage("Expected attribute [ %s ] to have value [ %s ] but was [ %s ]", new Object[]{attributeName, attributeValue, attr});
        }
        return this;
    }

    public HtmlAssert hasChild(String html) {
        Elements children = ((Element)this.actual).children();
        for (Element element : children) {
            if (!this.normalize(element).equals(this.normalize(HtmlAssert.toBody(html)))) continue;
            return this;
        }
        this.failWithMessage("Expected element to have child [ %s ]", new Object[]{html});
        return this;
    }

    public HtmlAssert hasTagName(String tagName) {
        if (!((Element)this.actual).tagName().equals(tagName)) {
            this.failWithMessage("Expected element to have tagName [\u00a0%s ] but was [ %s ]", new Object[]{tagName, ((Element)this.actual).tagName()});
        }
        return this;
    }

    private String normalize(Element element) {
        String html = StringUtil.normaliseWhitespace((String)element.outerHtml());
        return html.replace(" <", "<");
    }
}

