/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils.rule;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.mockito.Mockito;

public class TemporaryFragmentRepository
extends TemporaryFolder {
    private JacksonObjectMapper objectMapper = new JacksonObjectMapper(new ObjectMapper());
    private FragmentRepository repository;
    private WorkspacePathResolver pathResolver;

    public TemporaryFragmentRepository(WorkspacePathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    protected void before() throws Throwable {
        super.before();
        this.repository = new FragmentRepository(this.toPath(), new JsonFileBasedPersister(this.objectMapper, (BeanValidator)Mockito.mock(BeanValidator.class)), new JsonFileBasedLoader(this.objectMapper, Fragment.class), (BeanValidator)Mockito.mock(BeanValidator.class), (Watcher)Mockito.mock(Watcher.class));
        Mockito.when((Object)this.pathResolver.getFragmentsRepositoryPath()).thenReturn((Object)this.toPath());
    }

    public FragmentRepository toRepository() {
        return this.repository;
    }

    public Path resolveFragmentJson(String id) {
        return this.toPath().resolve(String.format("%s/%s.json", id, id));
    }

    public Path resolveFragmentMetadata(String id) {
        return this.toPath().resolve(String.format("%s/%s.metadata.json", id, id));
    }

    public Fragment addFragment(FragmentBuilder fragmentBuilder) {
        return (Fragment)this.repository.save((Identifiable)fragmentBuilder.build());
    }
}

