/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.FixBondsTypesVisitor;
import org.junit.Test;

public class FixBondsTypesVisitorTest {
    private FixBondsTypesVisitor fixBondsTypesVisitor = new FixBondsTypesVisitor(Arrays.asList(PropertyBuilder.aProperty().name("foo").bond(BondType.CONSTANT).build(), PropertyBuilder.aProperty().name("bar").bond(BondType.EXPRESSION).build()));
    private Component component = (Component)ComponentBuilder.aComponent().withPropertyValue("foo", "expression", "value").withPropertyValue("bar", "interpolation", "value").build();

    @Test
    public void should_fix_component_bond_when_visiting_it() {
        this.fixBondsTypesVisitor.visit(this.component);
        Assertions.assertThat((String)((PropertyValue)this.component.getPropertyValues().get("bar")).getType()).isEqualTo((Object)"constant");
    }

    @Test
    public void should_not_change_bond_if_type_in_inbound_expression_value() {
        this.fixBondsTypesVisitor.visit(this.component);
        Assertions.assertThat((String)((PropertyValue)this.component.getPropertyValues().get("foo")).getType()).isEqualTo((Object)"constant");
    }

    @Test
    public void should_visit_container_rows() {
        this.fixBondsTypesVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{this.component}).build());
        Assertions.assertThat((String)((PropertyValue)this.component.getPropertyValues().get("bar")).getType()).isEqualTo((Object)"constant");
    }

    @Test
    public void should_visit_previewable_rows() {
        this.fixBondsTypesVisitor.visit((Previewable)PageBuilder.aPage().with(new Element[]{this.component}).build());
        Assertions.assertThat((String)((PropertyValue)this.component.getPropertyValues().get("bar")).getType()).isEqualTo((Object)"constant");
    }

    @Test
    public void should_visit_container_from_tabs_container() {
        this.fixBondsTypesVisitor.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{this.component}))).build());
        Assertions.assertThat((String)((PropertyValue)this.component.getPropertyValues().get("bar")).getType()).isEqualTo((Object)"constant");
    }
}

