/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.model.page.Component;

public class ComponentBuilder
extends ElementBuilder<Component> {
    private Component component = new Component();

    private ComponentBuilder() {
    }

    public static ComponentBuilder aComponent() {
        return new ComponentBuilder();
    }

    public static ComponentBuilder aParagraph() throws Exception {
        return ComponentBuilder.aComponent("paragraph");
    }

    public static ComponentBuilder anInput() throws Exception {
        return ComponentBuilder.aComponent("input");
    }

    public static ComponentBuilder aComponent(String id) throws Exception {
        ComponentBuilder builder = new ComponentBuilder();
        return builder.withWidgetId(id);
    }

    public ComponentBuilder withWidgetId(String id) {
        this.component.setId(id);
        return this;
    }

    public ComponentBuilder withDescription(String description) {
        this.component.setDescription(description);
        return this;
    }

    @Override
    protected Component getElement() {
        return this.component;
    }

    @Override
    public Component build() {
        return this.component;
    }
}

