/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.builder.Dimension;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.PropertyValue;

public abstract class ElementBuilder<E extends Element> {
    public ElementBuilder<E> withDimension(int size) {
        return this.withDimensions(new Dimension("xs", size));
    }

    public ElementBuilder<E> withDimensions(Dimension ... dimensions) {
        for (Dimension dimension : dimensions) {
            this.getElement().getDimension().put(dimension.getKey(), dimension.getValue());
        }
        return this;
    }

    public ElementBuilder<E> withPropertyValue(String key, Object value) {
        return this.withPropertyValue(key, null, value);
    }

    public ElementBuilder<E> withPropertyValue(String key, String type, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.setType(type);
        propertyValue.setValue(value);
        this.getElement().getPropertyValues().put(key, propertyValue);
        return this;
    }

    public ElementBuilder<E> withReference(String reference) {
        this.getElement().setReference(reference);
        return this;
    }

    protected abstract E getElement();

    public abstract E build();
}

