/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.generator.parametrizedWidget.ParameterType;
import org.bonitasoft.web.designer.model.page.PropertyValue;

public class PropertyValueBuilder {
    private PropertyValue propertyValue;

    public static PropertyValueBuilder aPropertyValue() {
        return new PropertyValueBuilder(new PropertyValue());
    }

    public static PropertyValue aConstantPropertyValue(Object value) {
        return new PropertyValueBuilder(new PropertyValue()).withType(ParameterType.CONSTANT).withValue(value).build();
    }

    public static PropertyValue aDataPropertyValue(Object value) {
        return new PropertyValueBuilder(new PropertyValue()).withType(ParameterType.VARIABLE).withValue(value).build();
    }

    public static PropertyValue anExpressionPropertyValue(Object value) {
        return new PropertyValueBuilder(new PropertyValue()).withType(ParameterType.EXPRESSION).withValue(value).build();
    }

    public static PropertyValue aInterpolationPropertyValue(Object value) {
        return new PropertyValueBuilder(new PropertyValue()).withType(ParameterType.INTERPOLATION).withValue(value).build();
    }

    public PropertyValueBuilder withType(ParameterType type) {
        this.propertyValue.setType(type.getValue());
        return this;
    }

    public PropertyValueBuilder withValue(Object value) {
        this.propertyValue.setValue(value);
        return this;
    }

    private PropertyValueBuilder(PropertyValue value) {
        this.propertyValue = value;
    }

    public PropertyValue build() {
        return this.propertyValue;
    }
}

