/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.joda.time.Instant;

public class WidgetBuilder {
    private String id = UUID.randomUUID().toString();
    private String name = "aName";
    private boolean custom = false;
    private String template = "<h1>this is a template</h1>";
    private String controller;
    List<Property> properties = new ArrayList<Property>();
    private AssetBuilder[] assetBuilders;
    private Instant lastUpdate;
    private Set<String> modules = new HashSet<String>();
    private Set<String> authRules;
    private String designerVersion;
    private String modelVersion;
    private String previousDesignerVersion;
    private String previousArtifactVersion;
    private String type;
    private boolean favorite = false;
    private boolean hasHelp = false;
    private MigrationStatusReport migrationStatusReport = new MigrationStatusReport(true, true);

    public static WidgetBuilder aWidget() {
        return new WidgetBuilder();
    }

    public WidgetBuilder id(String id) {
        this.id = id;
        return this;
    }

    public WidgetBuilder name(String name) {
        this.name = name;
        return this;
    }

    public WidgetBuilder custom() {
        this.custom = true;
        return this;
    }

    public WidgetBuilder template(String template) {
        this.template = template;
        return this;
    }

    public WidgetBuilder controller(String controller) {
        this.controller = controller;
        return this;
    }

    public WidgetBuilder property(PropertyBuilder param) {
        return this.property(param.build());
    }

    public WidgetBuilder property(Property param) {
        this.properties.add(param);
        return this;
    }

    public WidgetBuilder lastUpdate(Instant instant) {
        this.lastUpdate = instant;
        return this;
    }

    public WidgetBuilder modules(String ... modules) {
        this.modules = Sets.newHashSet((Object[])modules);
        return this;
    }

    public WidgetBuilder authRules(String ... rules) {
        this.authRules = Sets.newHashSet((Object[])rules);
        return this;
    }

    public WidgetBuilder assets(AssetBuilder ... assetBuilders) {
        this.assetBuilders = assetBuilders;
        return this;
    }

    public WidgetBuilder designerVersion(String version) {
        this.designerVersion = version;
        return this;
    }

    public WidgetBuilder modelVersion(String version) {
        this.modelVersion = version;
        return this;
    }

    public WidgetBuilder previousDesignerVersion(String previousDesignerVersion) {
        this.previousDesignerVersion = previousDesignerVersion;
        return this;
    }

    public WidgetBuilder previousArtifactVersion(String previousArtifactVersion) {
        this.previousArtifactVersion = previousArtifactVersion;
        return this;
    }

    public WidgetBuilder favorite() {
        this.favorite = true;
        return this;
    }

    public WidgetBuilder notFavorite() {
        this.favorite = false;
        return this;
    }

    public WidgetBuilder type(String type) {
        this.type = type;
        return this;
    }

    public WidgetBuilder withMigrationStatusReport(MigrationStatusReport migrationStatusReport) {
        this.migrationStatusReport = migrationStatusReport;
        return this;
    }

    public WidgetBuilder isCompatible(boolean compatible) {
        this.migrationStatusReport.setCompatible(compatible);
        return this;
    }

    public WidgetBuilder isMigration(boolean migration) {
        this.migrationStatusReport.setMigration(migration);
        return this;
    }

    public Widget build() {
        Widget widget = new Widget();
        widget.setId(this.id);
        widget.setName(this.name);
        widget.setCustom(this.custom);
        widget.setTemplate(this.template);
        widget.setLastUpdate(this.lastUpdate);
        widget.setModelVersion(this.modelVersion);
        widget.setDesignerVersion(this.designerVersion);
        widget.setFavorite(this.favorite);
        widget.setHasHelp(this.hasHelp);
        widget.setType(this.type);
        if (this.previousArtifactVersion != null) {
            widget.setPreviousArtifactVersion(this.previousArtifactVersion);
        } else {
            widget.setPreviousDesignerVersion(this.previousDesignerVersion);
        }
        if (this.controller != null) {
            widget.setController(this.controller);
        }
        widget.setStatus(this.migrationStatusReport);
        if (this.assetBuilders != null) {
            for (AssetBuilder assetBuilder : this.assetBuilders) {
                widget.getAssets().add(assetBuilder.withComponentId(this.id).build());
            }
        }
        for (Property property : this.properties) {
            widget.addProperty(property);
        }
        widget.setRequiredModules(this.modules);
        widget.setAuthRules(this.authRules);
        return widget;
    }
}

