/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Sets;
import com.jayway.jsonassert.impl.matcher.IsCollectionWithSize;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.controller.FragmentResource;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.generator.mapping.Form;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.exception.InUseException;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.utils.RestControllerUtil;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.bonitasoft.web.designer.visitor.AssetVisitor;
import org.bonitasoft.web.designer.visitor.FragmentChangeVisitor;
import org.bonitasoft.web.designer.visitor.PageHasValidationErrorVisitor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class FragmentResourceTest {
    private MockMvc mockMvc;
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private SimpMessagingTemplate messagingTemplate;
    @Mock
    private FragmentService fragmentService;
    @Mock
    private AssetVisitor assetVisitor;
    private FragmentChangeVisitor fragmentChangeVisitor = new FragmentChangeVisitor();
    private PageHasValidationErrorVisitor pageHasValidationErrorVisitor = new PageHasValidationErrorVisitor();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        FragmentResource fragmentResource = new FragmentResource(this.fragmentRepository, this.fragmentService, new DesignerConfig().objectMapperWrapper(), this.messagingTemplate, this.assetVisitor, this.pageRepository, this.fragmentChangeVisitor, this.pageHasValidationErrorVisitor);
        fragmentResource.setUsedByRepositories(Arrays.asList(this.fragmentRepository, this.pageRepository));
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(fragmentResource).build();
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
    }

    @Test
    public void should_create_a_fragment() throws Exception {
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Collections.emptyList());
        Fragment fragment = FragmentBuilder.aFragment().withName("person").id("fragmentId").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("person")).thenReturn((Object)"person");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/fragments", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragment))).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)CoreMatchers.equalTo((Object)"person")));
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)Matchers.notNull(Fragment.class));
    }

    @Test
    public void should_respond_an_error_when_fragment_name_already_exist() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().withName("person").build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(fragment));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/fragments", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragment))).andExpect(MockMvcResultMatchers.status().is(403));
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("person")).thenReturn((Object)"person");
    }

    private Asset aPageAsset() {
        return AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).build();
    }

    private Asset aWidgetAsset() {
        return AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope(AssetScope.WIDGET).withComponentId("widget-id").build();
    }

    @Test
    public void should_save_a_fragment() throws Exception {
        Asset pageAsset = this.aPageAsset();
        Asset widgetAsset = this.aWidgetAsset();
        Fragment fragment = FragmentBuilder.aFragment().id("fragment1").withName("Person").with(pageAsset, widgetAsset).build();
        Mockito.when((Object)this.fragmentRepository.get("fragment1")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.get("fragment1")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("Person")).thenReturn((Object)"Person");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/rest/fragments/" + fragment.getId()), (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragment))).andExpect(MockMvcResultMatchers.status().isOk());
        ArgumentCaptor argument = ArgumentCaptor.forClass(Fragment.class);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)argument.capture());
        Assertions.assertThat((Object)argument.getValue()).isEqualTo((Object)fragment);
        Assertions.assertThat((Iterable)((Fragment)argument.getValue()).getAssets()).containsOnly((Object[])new Asset[]{pageAsset});
        ((SimpMessagingTemplate)Mockito.verify((Object)this.messagingTemplate)).convertAndSend((Object)"/previewableUpdates", (Object)fragment.getId());
    }

    @Test
    public void should_respond_422_on_save_when_fragment_is_incompatible() throws Exception {
        Asset pageAsset = this.aPageAsset();
        Asset widgetAsset = this.aWidgetAsset();
        Fragment fragment = FragmentBuilder.aFragment().id("fragment1").withName("Person").with(pageAsset, widgetAsset).isCompatible(false).build();
        Mockito.when((Object)this.fragmentRepository.get("fragment1")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.get("fragment1")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("Person")).thenReturn((Object)"Person");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/rest/fragments/" + fragment.getId()), (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragment))).andExpect(MockMvcResultMatchers.status().is(422));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Fragment.class);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)argument.capture());
    }

    @Test
    public void should_respond_an_error_when_changing_name_and_that_name_already_exist() throws Exception {
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(FragmentBuilder.aFragment().id("fragment1").withName("Person").build(), FragmentBuilder.aFragment().id("fragment2").withName("Persons").build()));
        Fragment fragment = FragmentBuilder.aFragment().id("fragment1").withName("Persons").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("Persons")).thenReturn((Object)"Persons");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/rest/fragments/" + fragment.getId()), (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragment))).andExpect(MockMvcResultMatchers.status().is(403));
    }

    @Test
    public void should_respond_415_unsuported_media_type_when_trying_to_save_non_json_content() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/my-fragment", (Object[])new Object[0]).content("this is not json")).andExpect(MockMvcResultMatchers.status().is(415));
    }

    @Test
    public void should_respond_500_internal_error_if_error_occurs_while_saving_a_page() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment")).thenReturn((Object)"fragment");
        ((FragmentRepository)Mockito.doThrow((Throwable)new RepositoryException("exception occured", (Throwable)new Exception())).when((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragment);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/rest/fragments/" + fragment.getId()), (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragment))).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_respond_404_when_trying_to_rename_an_unexisting_fragment() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("unknownfragment")).thenThrow(new Class[]{NotFoundException.class});
        Mockito.when((Object)this.fragmentService.get("unknownfragment")).thenThrow(new Class[]{NotFoundException.class});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/unknownfragment/name", (Object[])new Object[0]).contentType("application/json").content("newName")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_get_all_fragments() throws Exception {
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").withName("fragment1").build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("fragment2").withName("fragment2").build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(fragment1, fragment2));
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment1")).thenReturn((Object)"fragment1");
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment2")).thenReturn((Object)"fragment2");
        Mockito.when((Object)this.assetVisitor.visit((Previewable)fragment1)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{AssetBuilder.anAsset().withId("myAsset").build()}));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"fragment1", "fragment2"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].assets[0].id", (Object[])new Object[0]).value((Object)"myAsset"));
    }

    @Test
    public void should_get_all_fragment_light() throws Exception {
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").withName("fragment1").build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("fragment2").withName("fragment2").build();
        fragment2.setLastUpdate(Instant.parse((String)"2015-02-02"));
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(fragment1, fragment2));
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment1")).thenReturn((Object)"fragment1");
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment2")).thenReturn((Object)"fragment2");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments", (Object[])new Object[0]).param("view", new String[]{"light"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"fragment1", "fragment2"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].lastUpdate", (Object[])new Object[0]).value(IsCollectionContaining.hasItem((Object)Instant.parse((String)"2015-02-02").getMillis())));
    }

    @Test
    public void should_get_all_fragment_light_used_elsewhere() throws Exception {
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").withName("fragment1").build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("fragment2").withName("fragment2").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment1")).thenReturn((Object)"fragment1");
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment2")).thenReturn((Object)"fragment2");
        Page page1 = PageBuilder.aPage().build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(fragment1, fragment2));
        String[] ids = new String[]{"fragment1", "fragment2"};
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("fragment1", Arrays.asList(page1));
        Mockito.when((Object)this.pageRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(map);
        HashMap<String, List<Fragment>> map2 = new HashMap<String, List<Fragment>>();
        map2.put("fragment2", Arrays.asList(fragment1));
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(map2);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments", (Object[])new Object[0]).param("view", new String[]{"light"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"fragment1", "fragment2"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].usedBy.page", (Matcher)IsCollectionWithSize.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[1].usedBy.fragment", (Matcher)IsCollectionWithSize.hasSize((int)1)));
    }

    @Test
    public void should_get_all_fragment_used_elsewhere() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("fragment").build();
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Collections.singletonList(fragment));
        String[] ids = new String[]{"fragment"};
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("fragment", Arrays.asList(page));
        Mockito.when((Object)this.pageRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(map);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragment")).thenReturn((Object)"fragment");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].usedBy.page", (Matcher)IsCollectionWithSize.hasSize((int)1)));
    }

    @Test
    public void should_get_all_fragment_not_using_a_fragment_id() throws Exception {
        Mockito.when((Object)this.fragmentRepository.getAllNotUsingElement("used-fragment")).thenReturn(Arrays.asList(FragmentBuilder.aFragment().id("fragment1").build(), FragmentBuilder.aFragment().id("fragment2").build()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments", (Object[])new Object[0]).param("notUsedBy", new String[]{"used-fragment"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"fragment1", "fragment2"})));
    }

    @Test
    public void should_get_all_fragment_not_using_a_fragment_id_in_light_view() throws Exception {
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("fragment2").build();
        Page page1 = PageBuilder.aPage().build();
        Mockito.when((Object)this.fragmentRepository.getAllNotUsingElement("used-fragment")).thenReturn(Arrays.asList(fragment1, fragment2));
        String[] ids = new String[]{"fragment1", "fragment2"};
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("fragment1", Arrays.asList(page1));
        Mockito.when((Object)this.pageRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(map);
        HashMap<String, List<Fragment>> map2 = new HashMap<String, List<Fragment>>();
        map2.put("fragment2", Arrays.asList(fragment1));
        Mockito.when((Object)this.fragmentRepository.findByObjectIds(Arrays.asList(ids))).thenReturn(map2);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments", (Object[])new Object[0]).param("notUsedBy", new String[]{"used-fragment"}).param("view", new String[]{"light"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)IsCollectionWithSize.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[*].id", (Object[])new Object[0]).value(CoreMatchers.hasItems((Object[])new String[]{"fragment1", "fragment2"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].usedBy.page", (Matcher)IsCollectionWithSize.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[1].usedBy.fragment", (Matcher)IsCollectionWithSize.hasSize((int)1)));
    }

    @Test
    public void should_get_a_fragment_by_its_id() throws Exception {
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").build();
        Mockito.when((Object)this.fragmentService.get("fragment1")).thenReturn((Object)fragment1);
        Mockito.when((Object)this.assetVisitor.visit((Previewable)fragment1)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{AssetBuilder.anAsset().withId("myAsset").build()}));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments/fragment1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.assets[0].id", (Object[])new Object[0]).value((Object)"myAsset"));
    }

    @Test
    public void should_delete_a_fragment() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/fragments/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void should_not_allow_to_delete_a_fragment_used_in_a_page() throws Exception {
        Mockito.when((Object)this.pageRepository.containsObject("my-fragment")).thenReturn((Object)true);
        Mockito.when((Object)this.pageRepository.findByObjectId("my-fragment")).thenReturn(Arrays.asList(PageBuilder.aPage().withName("person").build()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/fragments/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isConflict()).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Matcher)CoreMatchers.is((Object)"The fragment cannot be deleted because it is used in 1 page, <person>")));
    }

    @Test
    public void should_not_allow_to_delete_a_fragment_used_in_another_fragment() throws Exception {
        Mockito.when((Object)this.fragmentRepository.containsObject("my-fragment")).thenReturn((Object)true);
        Mockito.when((Object)this.fragmentRepository.findByObjectId("my-fragment")).thenReturn(Arrays.asList(FragmentBuilder.aFragment().withName("person").build()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/fragments/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isConflict()).andExpect(MockMvcResultMatchers.jsonPath((String)"message", (Matcher)CoreMatchers.is((Object)"The fragment cannot be deleted because it is used in 1 fragment, <person>")));
    }

    @Test
    public void should_respond_404_not_found_if_fragment_is_not_existing() throws Exception {
        Mockito.when((Object)this.fragmentService.get("nonExistingFragment")).thenThrow(new Throwable[]{new NotFoundException("fragment not found")});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments/nonExistingFragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_404_not_found_when_delete_inexisting_fragment() throws Exception {
        ((FragmentRepository)Mockito.doThrow((Throwable)new NotFoundException("fragment not found")).when((Object)this.fragmentRepository)).delete("my-fragment");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/fragments/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void should_respond_500_internal_error_when_error_on_deletion_fragment() throws Exception {
        ((FragmentRepository)Mockito.doThrow((Throwable)new RepositoryException("error occurs", (Throwable)new RuntimeException())).when((Object)this.fragmentRepository)).delete("my-fragment");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/fragments/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void should_respond_409_conflict_error_when_fragment_inuse_elsewhere() throws Exception {
        ((FragmentRepository)Mockito.doThrow((Throwable)new InUseException("fragment in use")).when((Object)this.fragmentRepository)).delete("my-fragment");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/fragments/my-fragment", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isConflict());
    }

    @Test
    public void should_rename_a_fragment() throws Exception {
        String newName = "myNewFragment";
        Fragment fragment = FragmentBuilder.aFragment().withName("oldName").id("myFragment").with(ComponentBuilder.anInput()).build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Mockito.when((Object)this.fragmentRepository.get(fragment.getId())).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.get(fragment.getId())).thenReturn((Object)fragment);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/myFragment/name", (Object[])new Object[0]).content(newName)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/" + newName));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Fragment.class);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)argument.capture());
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).getNextAvailableId(newName);
        Assertions.assertThat((String)((Fragment)argument.getValue()).getName()).isEqualTo((Object)newName);
        Assertions.assertThat((String)((Fragment)argument.getValue()).getId()).isEqualTo((Object)newName);
        Assertions.assertThat((List)((Fragment)argument.getValue()).getRows()).isEqualTo((Object)fragment.getRows());
        Assertions.assertThat((Iterable)((Fragment)argument.getValue()).getAssets()).isEqualTo((Object)fragment.getAssets());
    }

    @Test
    public void should_throw_NotAllowedException_when_rename_a_fragment_who_new_name_already_exist() throws Exception {
        Fragment myFragmentToRename = FragmentBuilder.aFragment().id("my-fragment").withName("oldName").build();
        Mockito.when((Object)this.fragmentRepository.getAll()).thenReturn(Arrays.asList(FragmentBuilder.aFragment().id("my-fragment1").withName("newName").build(), myFragmentToRename));
        Mockito.when((Object)this.fragmentRepository.get(myFragmentToRename.getId())).thenReturn((Object)myFragmentToRename);
        Mockito.when((Object)this.fragmentService.get(myFragmentToRename.getId())).thenReturn((Object)myFragmentToRename);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/my-fragment/name", (Object[])new Object[0]).content("newName")).andExpect(MockMvcResultMatchers.status().is(403));
    }

    @Test
    public void should_mark_a_page_as_favorite() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/my-fragment/favorite", (Object[])new Object[0]).contentType("application/json").content("true")).andExpect(MockMvcResultMatchers.status().isOk());
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).markAsFavorite("my-fragment");
    }

    @Test
    public void should_unmark_a_page_as_favorite() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/my-fragment/favorite", (Object[])new Object[0]).contentType("application/json").content("false")).andExpect(MockMvcResultMatchers.status().isOk());
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).unmarkAsFavorite("my-fragment");
    }

    @Test
    public void should_save_a_fragment_renaming_it() throws Exception {
        Fragment fragmentToBeUpdated = FragmentBuilder.aFragment().id("myFragment").withName("myFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragmentToBeUpdated);
        Mockito.when((Object)this.fragmentService.get("myFragment")).thenReturn((Object)fragmentToBeUpdated);
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().withName("myNewFragment").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/myFragment", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)FragmentBuilder.aFragment().id("myNewFragment").withName("myNewFragment").build());
        ((SimpMessagingTemplate)Mockito.verify((Object)this.messagingTemplate)).convertAndSend((Object)"/previewableRemoval", (Object)"myFragment");
    }

    @Test
    public void should_update_reference_of_fragment_in_a_page_when_fragment_is_saving_with_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().id("myNewFragment").withName("myNewFragment").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        FragmentElement fragmentExpected = (FragmentElement)((List)page.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_use_in_two_container_when_fragment_is_saving_with_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(ContainerBuilder.aContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}))).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().id("myNewFragment").withName("myNewFragment").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        Container firstContainer = (Container)((List)page.getRows().get(0)).get(0);
        Container secondContainer = (Container)((List)firstContainer.getRows().get(0)).get(0);
        FragmentElement fragmentExpected = (FragmentElement)((List)secondContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        FragmentElement fragmentExpected = (FragmentElement)((List)page.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_use_in_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build()}).build();
        this.fragmentChangeVisitor.setNewFragmentId("myNewFragment");
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        Container container = (Container)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentExpected = (FragmentElement)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_use_in_form_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build())).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        FormContainer formContainer = (FormContainer)((List)page.getRows().get(0)).get(0);
        Container container = formContainer.getContainer();
        FragmentElement fragmentExpected = (FragmentElement)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_in_a_modal_container_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build())).build();
        this.fragmentChangeVisitor.setNewFragmentId("myNewFragment");
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        ModalContainer modalContainer = (ModalContainer)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentExpected = (FragmentElement)((List)modalContainer.getContainer().getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_only_good_fragment_use_in_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        FragmentElement myFragmentElementToKeep = new FragmentElement();
        myFragmentElementToKeep.setId("myFragmentToKeep");
        myFragmentElementToKeep.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{ContainerBuilder.aContainer().with(new Element[]{fragmentElement, myFragmentElementToKeep}).build()}).build();
        Fragment myFragmentToKeep = FragmentBuilder.aFragment().id("myFragmentToKeep").withName("myFragmentToKeep").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragmentToKeep")).thenReturn((Object)myFragmentToKeep);
        Mockito.when((Object)this.fragmentService.get("myFragmentToKeep")).thenReturn((Object)myFragmentToKeep);
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(myFragmentToKeep.getId())).thenReturn(Arrays.asList(page));
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        Container container = (Container)((List)page.getRows().get(0)).get(0);
        FragmentElement fragmentExpectedNoChange = (FragmentElement)((List)container.getRows().get(0)).get(1);
        FragmentElement fragmentExpected = (FragmentElement)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        Assertions.assertThat((String)fragmentExpectedNoChange.getId()).isEqualTo((Object)"myFragmentToKeep");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_use_in_tab_container_in_a_page_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        TabsContainerBuilder tabs = TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{fragmentElement}).build()));
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(tabs).build();
        this.fragmentChangeVisitor.setNewFragmentId("myNewFragment");
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        TabsContainer tabContainer = (TabsContainer)((List)page.getRows().get(0)).get(0);
        Container container = ((TabContainer)tabContainer.getTabList().get(0)).getContainer();
        FragmentElement fragmentExpected = (FragmentElement)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    public void should_update_reference_of_fragment_in_a_form_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Form form = new Form("myForm");
        form.setId("myForm");
        form.addNewRow((Element)fragmentElement);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(form.getId())).thenReturn((Object)form);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(form));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        FragmentElement fragmentExpected = (FragmentElement)((List)form.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)form);
    }

    @Test
    public void should_update_reference_of_fragment_in_a_layout_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("aFragment");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Page layout = PageBuilder.aPage().withId("myLayout").withName("myLayout").withType("layout").with(new Element[]{fragmentElement}).withVariable("aVariable", VariableBuilder.aConstantVariable().value("a value")).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("aFragment").withName("aFragment").build();
        Mockito.when((Object)this.fragmentRepository.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("aFragment")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("myNewFragment")).thenReturn((Object)"myNewFragment");
        Mockito.when((Object)this.pageRepository.get(layout.getId())).thenReturn((Object)layout);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(layout));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/aFragment/name", (Object[])new Object[0]).content("myNewFragment")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/myNewFragment"));
        FragmentElement fragmentExpected = (FragmentElement)((List)layout.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"myNewFragment");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)layout);
    }

    @Test
    public void should_update_reference_of_fragment_in_an_parent_fragment_when_fragment_is_saving_with_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("fragmentChild");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Fragment fragmentParent = FragmentBuilder.aFragment().id("fragmentParent").with(new Element[]{fragmentElement}).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentParent")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentParent")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(fragmentParent));
        Fragment fragmentToBeSaved = FragmentBuilder.aFragment().id("fragmentChildRenaming").withName("fragmentChildRenaming").build();
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChildRenaming")).thenReturn((Object)"fragmentChildRenaming");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToBeSaved))).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/fragmentChildRenaming"));
        FragmentElement fragmentExpected = (FragmentElement)((List)fragmentParent.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"fragmentChildRenaming");
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentParent);
    }

    @Test
    public void should_update_reference_of_fragment_in_an_parent_fragment_when_fragment_is_renaming() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setId("fragmentChild");
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        Fragment fragmentParent = FragmentBuilder.aFragment().id("fragmentParent").with(new Element[]{fragmentElement}).build();
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentParent")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentParent")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(fragmentParent));
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChildRenaming")).thenReturn((Object)"fragmentChildRenaming");
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild/name", (Object[])new Object[0]).content("fragmentChildRenaming")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Location", "/rest/fragments/fragmentChildRenaming"));
        FragmentElement fragmentExpected = (FragmentElement)((List)fragmentParent.getRows().get(0)).get(0);
        Assertions.assertThat((String)fragmentExpected.getId()).isEqualTo((Object)"fragmentChildRenaming");
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentParent);
    }

    @Test
    public void should_update_to_true_parent_page_when_validation_error_status_changes() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElement.setId("fragmentChild");
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).build();
        page.setHasValidationError(false);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChild")).thenReturn((Object)"fragmentChild");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToSave))).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((boolean)page.getHasValidationError()).isTrue();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToUpdated);
    }

    @Test
    public void should_update_to_true_parent_fragment_when_validation_error_status_changes() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElement.setId("fragmentChild");
        Fragment fragmentParent = FragmentBuilder.aFragment().id("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).build();
        fragmentParent.setHasValidationError(false);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChild")).thenReturn((Object)"fragmentChild");
        Mockito.when((Object)this.fragmentRepository.get(fragmentParent.getId())).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(fragmentParent));
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToSave))).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isTrue();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToUpdated);
    }

    @Test
    public void should_update_to_true_parent_page_of_parent_fragment_when_validation_error_status_changes() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(false);
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElement.setId("fragmentChild");
        FragmentElement fragmentElementParent = new FragmentElement();
        fragmentElementParent.setHasValidationError(false);
        fragmentElementParent.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElementParent.setId("parentFragment");
        Fragment fragmentParent = FragmentBuilder.aFragment().id("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).build();
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElementParent}).build();
        page.setHasValidationError(false);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChild")).thenReturn((Object)"fragmentChild");
        Mockito.when((Object)this.fragmentRepository.get("parentFragment")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentService.get("parentFragment")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("parentFragment")).thenReturn((Object)"parentFragment");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToSave))).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((boolean)page.getHasValidationError()).isTrue();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToUpdated);
    }

    @Test
    public void should_update_to_false_parent_page_when_validation_error_status_changes() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(true);
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElement.setId("fragmentChild");
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElement}).build();
        page.setHasValidationError(true);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChild")).thenReturn((Object)"fragmentChild");
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(page));
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToSave))).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((boolean)page.getHasValidationError()).isFalse();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToUpdated);
    }

    @Test
    public void should_update_to_false_parent_fragment_when_validation_error_status_changes() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(true);
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElement.setId("fragmentChild");
        Fragment fragmentParent = FragmentBuilder.aFragment().id("fragmentParent").withName("fragmentParent").with(new Element[]{fragmentElement}).build();
        fragmentParent.setHasValidationError(true);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChild")).thenReturn((Object)"fragmentChild");
        Mockito.when((Object)this.fragmentRepository.get("fragmentParent")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.findByObjectId("fragmentChild")).thenReturn(Arrays.asList(fragmentParent));
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToSave))).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isFalse();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToUpdated);
    }

    @Test
    public void should_update_to_false_parent_page_of_parent_fragment_when_validation_error_status_changes() throws Exception {
        FragmentElement fragmentElement = new FragmentElement();
        fragmentElement.setHasValidationError(true);
        fragmentElement.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElement.setId("fragmentChild");
        FragmentElement fragmentElementParent = new FragmentElement();
        fragmentElementParent.setHasValidationError(true);
        fragmentElementParent.setDimension((Map)ImmutableSortedMap.of((Comparable)((Object)"md"), (Object)8));
        fragmentElementParent.setId("parentFragment");
        Fragment fragmentParent = FragmentBuilder.aFragment().id("parentFragment").withName("parentFragment").with(new Element[]{fragmentElement}).withHasValidationError(true).build();
        Page page = PageBuilder.aPage().withId("myPage").withName("myPage").with(new Element[]{fragmentElementParent}).build();
        page.setHasValidationError(true);
        Fragment fragmentToUpdated = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(true).build();
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        Mockito.when((Object)this.fragmentRepository.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToUpdated);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("fragmentChild")).thenReturn((Object)"fragmentChild");
        Mockito.when((Object)this.fragmentRepository.get("parentFragment")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentService.get("parentFragment")).thenReturn((Object)fragmentParent);
        Mockito.when((Object)this.fragmentRepository.getNextAvailableId("parentFragment")).thenReturn((Object)"parentFragment");
        Mockito.when((Object)this.fragmentRepository.findByObjectId(fragmentToUpdated.getId())).thenReturn(Arrays.asList(fragmentParent));
        Mockito.when((Object)this.pageRepository.get(page.getId())).thenReturn((Object)page);
        Mockito.when((Object)this.pageRepository.findByObjectId(fragmentParent.getId())).thenReturn(Arrays.asList(page));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/fragments/fragmentChild", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(fragmentToSave))).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((boolean)fragmentParent.getHasValidationError()).isFalse();
        Assertions.assertThat((boolean)page.getHasValidationError()).isFalse();
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentToUpdated);
    }

    @Test
    public void should_respond_422_when_custom_widget_is_incompatible() throws Exception {
        Fragment fragmentToSave = FragmentBuilder.aFragment().id("fragmentChild").withName("fragmentChild").withHasValidationError(false).build();
        fragmentToSave.setStatus(new MigrationStatusReport(false, true));
        Mockito.when((Object)this.fragmentService.get("fragmentChild")).thenReturn((Object)fragmentToSave);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/fragments/fragmentChild", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(422));
    }
}

