/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.export.Zipper;
import org.bonitasoft.web.designer.controller.export.steps.WidgetsExportStep;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.DirectiveFileGenerator;
import org.bonitasoft.web.designer.rendering.Minifier;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryWidgetRepository;
import org.bonitasoft.web.designer.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetsExportStepTest {
    private WorkspacePathResolver pathResolver = (WorkspacePathResolver)Mockito.mock(WorkspacePathResolver.class);
    private FragmentRepository fragmentRepository;
    @Rule
    public TemporaryWidgetRepository repository = new TemporaryWidgetRepository(this.pathResolver);
    private WidgetsExportStep step;
    @Mock
    private Zipper zipper;
    @Mock
    private DirectiveFileGenerator directiveFileGenerator;

    @Before
    public void beforeEach() {
        this.step = new WidgetsExportStep(this.pathResolver, new WidgetIdVisitor(this.fragmentRepository), this.directiveFileGenerator);
        this.zipper = (Zipper)Mockito.spy((Object)new Zipper((OutputStream)Mockito.mock(OutputStream.class)));
    }

    @Test
    public void should_add_page_widgets_to_zip() throws Exception {
        this.repository.addWidget(WidgetBuilder.aWidget().id("widget1"));
        this.repository.addWidget(WidgetBuilder.aWidget().id("widget2"));
        Page page = PageBuilder.aPage().with(ComponentBuilder.aComponent("widget1"), ComponentBuilder.aComponent("widget2")).build();
        String content = "Mon   content   to                 minify";
        byte[] expected = Minifier.minify((byte[])content.getBytes());
        Mockito.when((Object)this.directiveFileGenerator.getWidgetsFilesUsedInPage((Previewable)page)).thenReturn(Arrays.asList(Paths.get("widget1", new String[0]), Paths.get("widget2", new String[0])));
        Mockito.when((Object)this.directiveFileGenerator.concatenate(Arrays.asList(Paths.get("widget1", new String[0]), Paths.get("widget2", new String[0])))).thenReturn((Object)content.getBytes());
        this.step.execute(this.zipper, (AbstractPage)page);
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(this.repository.resolveWidgetJson("widget1"), "resources/widgets/widget1/widget1.json");
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(this.repository.resolveWidgetJson("widget2"), "resources/widgets/widget2/widget2.json");
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(expected, "resources/js/widgets-" + DigestUtils.sha1Hex((byte[])expected) + ".min.js");
    }

    @Test
    public void should_not_add_widget_metadata_to_zip() throws Exception {
        this.repository.addWidget(WidgetBuilder.aWidget().id("widget"));
        Page page = PageBuilder.aPage().with(ComponentBuilder.aComponent("widget")).build();
        String content = "content";
        Mockito.when((Object)this.directiveFileGenerator.getWidgetsFilesUsedInPage((Previewable)page)).thenReturn(Arrays.asList(Paths.get("widget", new String[0])));
        Mockito.when((Object)this.directiveFileGenerator.concatenate(Arrays.asList(Paths.get("widget", new String[0])))).thenReturn((Object)content.getBytes());
        this.step.execute(this.zipper, (AbstractPage)page);
        ((Zipper)Mockito.verify((Object)this.zipper, (VerificationMode)Mockito.never())).addToZip(this.repository.resolveWidgetMetadata("widget"), "resources/widgets/widget/widget.metadata.json");
    }
}

