/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.mapping.data.FormInputVisitor;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.ContractInputVisitor;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.junit.Before;
import org.junit.Test;

public class FormInputVisitorTest {
    JacksonObjectMapper objectMapper = new JacksonObjectMapper(new ObjectMapper());
    FormInputVisitor visitor;

    @Before
    public void setUp() throws Exception {
        this.visitor = new FormInputVisitor(this.objectMapper);
    }

    @Test
    public void should_build_form_input_from_simple_types() throws Exception {
        Contract contract = ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aBooleanContractInput((String)"accepted"), ContractInputBuilder.anIntegerContractInput((String)"age"), ContractInputBuilder.aStringContractInput((String)"name")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJson()).isEqualTo((Object)this.objectMapper.prettyPrint("{\"accepted\":false,\"age\":0,\"name\":\"\"}"));
    }

    @Test
    public void should_build_form_input_from_complex_types() throws Exception {
        Contract contract = ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"person").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"name"), ContractInputBuilder.aNodeContractInput((String)"details").withInput(new ContractInput[]{ContractInputBuilder.anIntegerContractInput((String)"age")}).build()}).build(), ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJson()).isEqualTo((Object)this.objectMapper.prettyPrint("{\"person\":{\"name\":\"\",\"details\":{\"age\":0}},\"accepted\":false}"));
    }

    @Test
    public void should_ignore_complex_types_with_dataRef_in_formInput_in_edit_mode() throws Exception {
        Contract contract = ContractBuilder.aContract().inEditMode().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"person").withDataReference(new BusinessDataReference("person", "org.test.Person", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"name"), ContractInputBuilder.aNodeContractInput((String)"details").withInput(new ContractInput[]{ContractInputBuilder.anIntegerContractInput((String)"age")}).build()}).build(), ContractInputBuilder.aBooleanContractInput((String)"accepted")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJson()).isEqualTo((Object)this.objectMapper.prettyPrint("{\"accepted\":false}"));
    }

    @Test
    public void should_add_an_empty_list_when_input_is_multiple() throws Exception {
        Contract contract = ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"persons").mulitple().build(), ContractInputBuilder.aMultipleStringContractInput((String)"roles")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJson()).isEqualTo((Object)this.objectMapper.prettyPrint("{\"persons\":[],\"roles\":[]}"));
    }

    @Test
    public void should_default_to_null_when_contract_input_is_a_file() throws Exception {
        Contract contract = ContractBuilder.aContract().withInput(new ContractInput[]{ContractInputBuilder.aFileContractInput((String)"myFile")}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJson()).isEqualTo((Object)this.objectMapper.prettyPrint("{\"myFile\":null}"));
    }

    @Test
    public void should_accept_non_mandatory_local_date() throws Exception {
        LeafContractInput aLocalDateContractInput = ContractInputBuilder.aLocalDateContractInput((String)"myDate");
        LeafContractInput aLocalDateTimeContractInput = new LeafContractInput("myLocalDateTime", LocalDateTime.class);
        LeafContractInput aOffsetDateTimeContractInput = new LeafContractInput("myOffsetDateTime", OffsetDateTime.class);
        LeafContractInput aLegacyDateContractInput = new LeafContractInput("myLgacyDate", Date.class);
        aLocalDateContractInput.setMandatory(false);
        aLocalDateTimeContractInput.setMandatory(false);
        aOffsetDateTimeContractInput.setMandatory(false);
        aLegacyDateContractInput.setMandatory(false);
        Contract contract = ContractBuilder.aContract().withInput(new ContractInput[]{aLocalDateContractInput, aLocalDateTimeContractInput, aOffsetDateTimeContractInput, aLegacyDateContractInput}).build();
        contract.accept((ContractInputVisitor)this.visitor);
        Assertions.assertThat((String)this.visitor.toJson()).contains(new CharSequence[]{"\"myDate\" : null"});
        Assertions.assertThat((String)this.visitor.toJson()).contains(new CharSequence[]{"\"myLocalDateTime\" : null"});
        Assertions.assertThat((String)this.visitor.toJson()).contains(new CharSequence[]{"\"myOffsetDateTime\" : null"});
        Assertions.assertThat((String)this.visitor.toJson()).contains(new CharSequence[]{"\"myLgacyDate\" : null"});
    }
}

