/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.parametrizedWidget;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.parametrizedWidget.InputTypeResolver;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.junit.Before;
import org.junit.Test;

public class AttributeInputTypeResolverTest {
    private InputTypeResolver inputTypeResolver;

    @Before
    public void init() {
        this.inputTypeResolver = new InputTypeResolver();
    }

    @Test
    public void should_detect_text_input() {
        LeafContractInput input = new LeafContractInput("input", String.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.TEXT);
    }

    @Test
    public void should_detect_numeric_input() {
        LeafContractInput input = new LeafContractInput("input", Integer.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.NUMERIC);
    }

    @Test
    public void should_detect_local_date_input() {
        LeafContractInput input = new LeafContractInput("input", LocalDate.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.LOCAL_DATE);
        input = new LeafContractInput("input", Date.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.LOCAL_DATE);
    }

    @Test
    public void should_detect_date_time_input() {
        LeafContractInput input = new LeafContractInput("input", LocalDateTime.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.LOCAL_DATE_TIME);
    }

    @Test
    public void should_detect_offset_date_time_input() {
        LeafContractInput input = new LeafContractInput("input", OffsetDateTime.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.OFFSET_DATE_TIME);
    }

    @Test
    public void should_detect_boolean_input() {
        LeafContractInput input = new LeafContractInput("input", Boolean.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.BOOLEAN);
    }

    @Test
    public void should_detect_file_input() {
        LeafContractInput input = new LeafContractInput("input", File.class);
        Assertions.assertThat((Comparable)this.inputTypeResolver.getContractInputType((ContractInput)input)).isEqualTo((Object)InputTypeResolver.InputType.FILE);
    }

    @Test
    public void should_detect_date_input() {
        LeafContractInput input = new LeafContractInput("input", LocalDate.class);
        Assertions.assertThat((boolean)this.inputTypeResolver.isDateInput((ContractInput)input)).isTrue();
        input = new LeafContractInput("input", Date.class);
        Assertions.assertThat((boolean)this.inputTypeResolver.isDateInput((ContractInput)input)).isTrue();
        input = new LeafContractInput("input", LocalDateTime.class);
        Assertions.assertThat((boolean)this.inputTypeResolver.isDateInput((ContractInput)input)).isTrue();
        input = new LeafContractInput("input", OffsetDateTime.class);
        Assertions.assertThat((boolean)this.inputTypeResolver.isDateInput((ContractInput)input)).isTrue();
        input = new LeafContractInput("input", Boolean.class);
        Assertions.assertThat((boolean)this.inputTypeResolver.isDateInput((ContractInput)input)).isFalse();
    }
}

