/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.repository;

import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.exception.ConstraintValidationException;
import org.junit.Test;

public class BeanValidatorTest {
    @Test
    public void should_do_nothing_if_bean_is_valid() throws Exception {
        BeanValidator validator = new BeanValidator(Validation.buildDefaultValidatorFactory().getValidator());
        validator.validate((Object)TestBean.aValidBean());
    }

    @Test(expected=ConstraintValidationException.class)
    public void should_throw_constraintViolationException_when_bean_is_not_valid() throws Exception {
        BeanValidator validator = new BeanValidator(Validation.buildDefaultValidatorFactory().getValidator());
        validator.validate((Object)TestBean.anInvalidBean());
    }

    public static class TestBean {
        @NotNull
        private String valid;

        public TestBean(String valid) {
            this.valid = valid;
        }

        public static TestBean aValidBean() {
            return new TestBean("valid");
        }

        public static TestBean anInvalidBean() {
            return new TestBean(null);
        }
    }
}

