/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import javax.inject.Inject;
import javax.validation.Validation;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.ApplicationConfig;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={ApplicationConfig.class, DesignerConfig.class})
@WebAppConfiguration(value="src/test/resources")
public class PageRepositoryIT {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private JsonFileBasedPersister<Page> persister;
    private JsonFileBasedLoader<Page> loader;
    private Path pagesPath;
    private PageRepository repository;
    @Inject
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        this.pagesPath = Paths.get(this.temporaryFolder.getRoot().getPath(), new String[0]);
        this.persister = (JsonFileBasedPersister)Mockito.spy((Object)new DesignerConfig().pageFileBasedPersister());
        this.loader = (JsonFileBasedLoader)Mockito.spy((Object)new DesignerConfig().pageFileBasedLoader());
        this.repository = new PageRepository(this.pagesPath, this.persister, this.loader, new BeanValidator(Validation.buildDefaultValidatorFactory().getValidator()), (Watcher)Mockito.mock(Watcher.class));
    }

    @Test
    public void should_save_variables_values_as_array_in_a_json_file_repository() throws Exception {
        Page expectedPage = PageBuilder.aFilledPage("page-id");
        File pageFile = this.pagesPath.resolve(expectedPage.getId()).resolve(expectedPage.getId() + ".json").toFile();
        Assertions.assertThat((File)pageFile).doesNotExist();
        this.repository.saveAll(Collections.singletonList(expectedPage));
        Assertions.assertThat((File)pageFile).exists();
        JsonNode pageNode = this.objectMapper.readTree(pageFile);
        Assertions.assertThat((boolean)pageNode.at("/variables/aVariable/value").isArray()).isTrue();
        Assertions.assertThat((String)((JsonNode)pageNode.at("/variables/aVariable/value").elements().next()).asText()).isEqualTo((Object)"a value");
        Assertions.assertThat((boolean)pageNode.at("/variables/aVariable").has("displayValue")).isFalse();
    }

    @Test
    public void should_not_contain_data_in_json_file_repository() throws Exception {
        Page expectedPage = PageBuilder.aFilledPage("page-id");
        File pageFile = this.pagesPath.resolve(expectedPage.getId()).resolve(expectedPage.getId() + ".json").toFile();
        Assertions.assertThat((File)pageFile).doesNotExist();
        this.repository.saveAll(Collections.singletonList(expectedPage));
        Assertions.assertThat((File)pageFile).exists();
        JsonNode pageNode = this.objectMapper.readTree(pageFile);
        Assertions.assertThat((String)pageNode.at("/data").asText()).isEqualTo((Object)"");
    }
}

