/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.repository;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.WidgetFileBasedPersister;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class WigetFileBasedPersisterTest {
    private static final String DESIGNER_VERSION = "2.0.0";
    private Path repoDirectory;
    private JacksonObjectMapper objectMapper;
    private WidgetFileBasedPersister widgetPersister;
    @Mock
    private BeanValidator validator;

    @Before
    public void setUp() throws IOException {
        this.repoDirectory = Files.createTempDirectory("jsonrepository", new FileAttribute[0]);
        this.objectMapper = (JacksonObjectMapper)Mockito.spy((Object)new DesignerConfig().objectMapperWrapper());
        this.widgetPersister = new WidgetFileBasedPersister(this.objectMapper, this.validator);
        ReflectionTestUtils.setField((Object)this.widgetPersister, (String)"uidVersion", (Object)DESIGNER_VERSION);
    }

    @After
    public void clean() {
        FileUtils.deleteQuietly((File)this.repoDirectory.toFile());
    }

    private Widget getFromRepository(String id) throws IOException {
        byte[] json = Files.readAllBytes(this.repoDirectory.resolve(id + ".json"));
        return (Widget)this.objectMapper.fromJson(json, Widget.class);
    }

    @Test
    public void should_serialize_an_object_and_save_it_to_a_file() throws Exception {
        String templateFileName = "input.tpl.html";
        String controllerFileName = "input.ctrl.js";
        String htmlContent = "<div></div>";
        String jsContent = "function ($scope) {}";
        Widget widgetToSave = WidgetBuilder.aWidget().id("input").template(htmlContent).controller(jsContent).build();
        this.widgetPersister.save(this.repoDirectory, widgetToSave);
        Widget savedObject = this.getFromRepository("input");
        Assertions.assertThat((String)savedObject.getTemplate()).isEqualTo((Object)("@" + widgetToSave.getId() + ".tpl.html"));
        Assertions.assertThat((String)savedObject.getController()).isEqualTo((Object)("@" + widgetToSave.getId() + ".ctrl.js"));
        Assertions.assertThat((String)Files.readAllLines(this.repoDirectory.resolve(widgetToSave.getId() + ".ctrl.js"), StandardCharsets.UTF_8).get(0)).isEqualTo((Object)jsContent);
        Assertions.assertThat((String)Files.readAllLines(this.repoDirectory.resolve(widgetToSave.getId() + ".tpl.html"), StandardCharsets.UTF_8).get(0)).isEqualTo((Object)htmlContent);
    }
}

