/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Arrays;
import java.util.HashSet;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.service.FragmentMigrationApplyer;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.visitor.FragmentIdVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class FragmentServiceTest {
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private FragmentMigrationApplyer fragmentMigrationApplyer;
    @Mock
    private FragmentIdVisitor fragmentIdVisitor;
    @InjectMocks
    private FragmentService fragmentService;

    @Before
    public void setUp() {
        this.fragmentService = new FragmentService(this.fragmentRepository, this.fragmentMigrationApplyer, this.fragmentIdVisitor);
        ReflectionTestUtils.setField((Object)this.fragmentService, (String)"modelVersion", (Object)"2.0");
    }

    @Test
    public void should_migrate_found_fragment_when_get_is_called() {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment fragmentMigrated = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("1.5.0").withPreviousDesignerVersion("1.0.0").build();
        MigrationResult mr = new MigrationResult((Object)fragmentMigrated, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS, "myFragmentBis")));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new MigrationStatusReport(true, false));
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(fragment, true)).thenReturn((Object)mr);
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment);
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(fragment, true);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
    }

    @Test
    public void should_not_save_fragment_when_migration_is_not_done() {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withModelVersion("2.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new MigrationStatusReport(true, false));
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer, (VerificationMode)Mockito.never())).migrate(fragment, true);
    }

    @Test
    public void should_not_save_fragment_when_migration_is_finish_in_error() {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment fragmentMigrated = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment);
        MigrationResult mr = new MigrationResult((Object)fragmentMigrated, Arrays.asList(new MigrationStepReport(MigrationStatus.ERROR, "myFragmentBis")));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new MigrationStatusReport(true, true));
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(fragment, true)).thenReturn((Object)mr);
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(fragment, true);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
    }

    @Test
    public void should_migrate_child_fragment_when_parent_fragment_is_migrate() {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragmentBis").withDesignerVersion("1.0.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment parentFragment = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("1.0.0").with(fragment).withPreviousDesignerVersion("1.0.0").build();
        Fragment fragmentMigrated = FragmentBuilder.aFragment().id("myFragmentBis").withDesignerVersion("2.0").withPreviousDesignerVersion("1.0.0").build();
        Fragment parentFragmentMigrated = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("2.0").withPreviousDesignerVersion("1.0.0").with(fragmentMigrated).build();
        MigrationResult mr = new MigrationResult((Object)fragmentMigrated, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS, "myFragmentBis")));
        MigrationResult parentMigrated = new MigrationResult((Object)parentFragmentMigrated, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS, "myFragment")));
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)parentFragment);
        Mockito.when((Object)this.fragmentRepository.get("myFragmentBis")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new MigrationStatusReport(true, true));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(parentFragment)).thenReturn((Object)new MigrationStatusReport(true, true));
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(parentFragment, true)).thenReturn((Object)parentMigrated);
        Mockito.when((Object)this.fragmentMigrationApplyer.migrate(fragment, false)).thenReturn((Object)mr);
        HashSet<String> h = new HashSet<String>(Arrays.asList("myFragmentBis"));
        Mockito.when((Object)this.fragmentRepository.getByIds(h)).thenReturn(Arrays.asList(fragment));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)parentFragment)).thenReturn(h);
        this.fragmentService.get("myFragment");
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(parentFragment, true);
        ((FragmentMigrationApplyer)Mockito.verify((Object)this.fragmentMigrationApplyer)).migrate(fragment, false);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)parentFragmentMigrated);
        ((FragmentRepository)Mockito.verify((Object)this.fragmentRepository)).updateLastUpdateAndSave((Identifiable)fragmentMigrated);
    }

    @Test
    public void should_get_correct_migration_status_when_dependency_is_to_migrate() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("fragment").withDesignerVersion("1.10.0").build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("fragment"));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new MigrationStatusReport(true, false));
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Arrays.asList(fragment));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(ids);
        MigrationStatusReport status = this.fragmentService.getMigrationStatusOfFragmentUsed((Previewable)page);
        Assert.assertEquals((Object)this.getMigrationStatusReport(true, true), (Object)status.toString());
    }

    @Test
    public void should_get_correct_migration_status_when_dependency_is_not_compatible() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").withDesignerVersion("1.10.0").build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("fragment2").withModelVersion("2.1").build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("fragment1", "fragment2"));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment1)).thenReturn((Object)new MigrationStatusReport(true, false));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment2)).thenReturn((Object)new MigrationStatusReport(false, false));
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Arrays.asList(fragment1, fragment2));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(ids);
        MigrationStatusReport status = this.fragmentService.getMigrationStatusOfFragmentUsed((Previewable)page);
        Assert.assertEquals((Object)this.getMigrationStatusReport(false, false), (Object)status.toString());
    }

    @Test
    public void should_get_correct_migration_status_when_fragment_contains_incompatible_fragment() throws Exception {
        Fragment fragment1 = FragmentBuilder.aFragment().id("fragment1").withDesignerVersion("1.10.0").build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("fragment2").withModelVersion("2.1").build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("fragment2"));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment1)).thenReturn((Object)new MigrationStatusReport(true, false));
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment2)).thenReturn((Object)new MigrationStatusReport(true, false));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)fragment1)).thenReturn(ids);
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Arrays.asList(fragment2));
        MigrationStatusReport status = this.fragmentService.getMigrationStatusOfFragmentUsed((Previewable)fragment1);
        Assert.assertEquals((Object)this.getMigrationStatusReport(false, false), (Object)status.toString());
    }

    @Test
    public void should_get_correct_migration_status_when_dependency_is_not_to_migrate() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("fragment").withDesignerVersion("2.0").isMigration(false).build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("fragment"));
        Mockito.when((Object)this.fragmentRepository.getByIds(ids)).thenReturn(Arrays.asList(fragment));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(ids);
        Mockito.when((Object)this.fragmentMigrationApplyer.getMigrationStatusOfCustomWidgetsUsed(fragment)).thenReturn((Object)new MigrationStatusReport(true, false));
        MigrationStatusReport status = this.fragmentService.getMigrationStatusOfFragmentUsed((Previewable)page);
        Assert.assertEquals((Object)this.getMigrationStatusReport(true, false), (Object)status.toString());
    }

    private String getMigrationStatusReport(boolean compatible, boolean migration) {
        return new MigrationStatusReport(compatible, migration).toString();
    }
}

