/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Collections;
import java.util.Optional;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.WidgetMigrationApplyer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetMigrationApplyerTest {
    @Test
    public void should_migrate_a_widget() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Optional<MigrationStepReport> stepReport = Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "customWidget"));
        Migration migrations = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        WidgetMigrationApplyer widgetMigrationApplyer = new WidgetMigrationApplyer(Collections.singletonList(migrations));
        Widget widget = WidgetBuilder.aWidget().id("customWidget").designerVersion("1.0.1").previousDesignerVersion("1.0.0").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)widget)).thenReturn(stepReport);
        widgetMigrationApplyer.migrate(widget);
        Assert.assertEquals((Object)widget.getPreviousArtifactVersion(), (Object)"1.0.1");
        Assert.assertEquals((Object)widget.getArtifactVersion(), (Object)"2.0");
    }

    @Test
    public void should_migrate_a_widget_with_new_model_version() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Optional<MigrationStepReport> stepReport = Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "customWidget"));
        Migration migrations = new Migration("2.1", new MigrationStep[]{mockMigrationStep});
        WidgetMigrationApplyer widgetMigrationApplyer = new WidgetMigrationApplyer(Collections.singletonList(migrations));
        Widget widget = WidgetBuilder.aWidget().id("customWidget").modelVersion("2.0").previousDesignerVersion("1.7.11").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)widget)).thenReturn(stepReport);
        widgetMigrationApplyer.migrate(widget);
        Assert.assertEquals((Object)widget.getPreviousArtifactVersion(), (Object)"2.0");
        Assert.assertEquals((Object)widget.getArtifactVersion(), (Object)"2.1");
    }

    @Test
    public void should_migrate_a_widget_with_no_previous_version() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Optional<MigrationStepReport> stepReport = Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "customWidget"));
        Migration migrations = new Migration("2.0", new MigrationStep[]{mockMigrationStep});
        WidgetMigrationApplyer widgetMigrationApplyer = new WidgetMigrationApplyer(Collections.singletonList(migrations));
        Widget widget = WidgetBuilder.aWidget().id("customWidget").designerVersion("1.0.1").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)widget)).thenReturn(stepReport);
        widgetMigrationApplyer.migrate(widget);
        Assert.assertEquals((Object)widget.getPreviousArtifactVersion(), (Object)"1.0.1");
        Assert.assertEquals((Object)widget.getArtifactVersion(), (Object)"2.0");
    }

    @Test
    public void should_not_modify_previous_model_version_when_no_migration_done_on_widget() {
        Migration migrations = new Migration("2.0", new MigrationStep[]{(MigrationStep)Mockito.mock(MigrationStep.class)});
        WidgetMigrationApplyer widgetMigrationApplyer = new WidgetMigrationApplyer(Collections.singletonList(migrations));
        Widget widget = WidgetBuilder.aWidget().id("customWidget").modelVersion("2.0").previousArtifactVersion("2.0").build();
        widgetMigrationApplyer.migrate(widget);
        Assert.assertEquals((Object)widget.getPreviousArtifactVersion(), (Object)"2.0");
        Assert.assertEquals((Object)widget.getArtifactVersion(), (Object)"2.0");
    }

    @Test
    public void should_return_an_report_with_error_when_error_occurs_during_widget_migration() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migrations = new Migration("2.1", new MigrationStep[]{mockMigrationStep});
        WidgetMigrationApplyer widgetMigrationApplyer = new WidgetMigrationApplyer(Collections.singletonList(migrations));
        Widget widget = WidgetBuilder.aWidget().id("customWidget").modelVersion("2.0").previousArtifactVersion("1.0.1").build();
        Mockito.when((Object)mockMigrationStep.migrate((Object)widget)).thenThrow(new Throwable[]{new Exception()});
        MigrationResult result = widgetMigrationApplyer.migrate(widget);
        Widget migratedWidget = (Widget)result.getArtifact();
        Assert.assertEquals((Object)migratedWidget.getPreviousArtifactVersion(), (Object)"2.0");
        Assert.assertEquals((Object)migratedWidget.getArtifactVersion(), (Object)"2.1");
        MigrationStepReport report = (MigrationStepReport)result.getMigrationStepReportList().get(0);
        Assert.assertEquals((Object)report.getMigrationStatus(), (Object)MigrationStatus.ERROR);
        Assert.assertEquals((Object)report.getArtifactId(), (Object)"customWidget");
    }
}

