/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.studio.workspace;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.studio.workspace.RestClientProperties;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.env.Environment;

@RunWith(value=MockitoJUnitRunner.class)
public class RestClientPropertiesTest {
    @InjectMocks
    private RestClientProperties restClientProperties;
    @Mock
    private Environment env;

    @Test
    public void should_retrieve_rest_api_url_from_system_property() throws Exception {
        Mockito.when((Object)this.env.getProperty("workspace.api.rest.url")).thenReturn((Object)"http://localhost:6666/workspace");
        Assertions.assertThat((String)this.restClientProperties.getUrl()).isEqualTo((Object)"http://localhost:6666/workspace");
    }

    @Test
    public void should_retrieve_null_url_if_system_property_not_set() throws Exception {
        Assertions.assertThat((String)this.restClientProperties.getUrl()).isNull();
    }

    @Test
    public void should_retrieve_false_if_system_property_not_set() throws Exception {
        Assertions.assertThat((boolean)this.restClientProperties.isURLSet()).isFalse();
    }

    @Test
    public void should_retrieve_true_if_system_property_is_set() throws Exception {
        Mockito.when((Object)this.env.getProperty("workspace.api.rest.url")).thenReturn((Object)"http://localhost:6666/workspace");
        Assertions.assertThat((boolean)this.restClientProperties.isURLSet()).isTrue();
    }
}

