/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils.rule;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.mockito.Mockito;

public class TemporaryWidgetRepository
extends TemporaryFolder {
    private JacksonObjectMapper objectMapper = new JacksonObjectMapper(new ObjectMapper());
    private WidgetRepository repository;
    private WorkspacePathResolver pathResolver;

    public TemporaryWidgetRepository(WorkspacePathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    protected void before() throws Throwable {
        super.before();
        this.repository = new WidgetRepository(this.toPath(), new JsonFileBasedPersister(this.objectMapper, (BeanValidator)Mockito.mock(BeanValidator.class)), (JsonFileBasedLoader)new WidgetFileBasedLoader(this.objectMapper), (BeanValidator)Mockito.mock(BeanValidator.class), (Watcher)Mockito.mock(Watcher.class));
        Mockito.when((Object)this.pathResolver.getWidgetsRepositoryPath()).thenReturn((Object)this.toPath());
    }

    public Path resolveWidgetJson(String id) {
        return this.toPath().resolve(String.format("%s/%s.json", id, id));
    }

    public Path resolveWidgetMetadata(String id) {
        return this.toPath().resolve(String.format("%s/%s.metadata.json", id, id));
    }

    public Widget addWidget(WidgetBuilder widgetBuilder) {
        return (Widget)this.repository.save((Identifiable)widgetBuilder.build());
    }
}

