/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.codec.digest.DigestUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.ResponsiveDimension;
import org.bonitasoft.web.designer.builder.RowBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.rendering.DirectivesCollector;
import org.bonitasoft.web.designer.rendering.GenerationException;
import org.bonitasoft.web.designer.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.repository.AssetRepository;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.utils.assertions.CustomAssertions;
import org.bonitasoft.web.designer.utils.rule.TestResource;
import org.bonitasoft.web.designer.visitor.AssetVisitor;
import org.bonitasoft.web.designer.visitor.HtmlBuilderVisitor;
import org.bonitasoft.web.designer.visitor.PageFactory;
import org.bonitasoft.web.designer.visitor.PropertyValuesVisitor;
import org.bonitasoft.web.designer.visitor.RequiredModulesVisitor;
import org.bonitasoft.web.designer.visitor.VariableModelVisitor;
import org.bonitasoft.web.designer.visitor.WidgetIdVisitor;
import org.jsoup.Jsoup;
import org.jsoup.select.Elements;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class HtmlBuilderVisitorTest {
    @Mock
    private PageFactory pageFactory;
    @Mock
    private RequiredModulesVisitor requiredModulesVisitor;
    @Mock
    private AssetVisitor assetVisitor;
    @Mock
    private AssetRepository<Page> pageAssetRepository;
    @Mock
    private AssetRepository<Widget> widgetAssetRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private PropertyValuesVisitor propertyValuesVisitor;
    @Mock
    private VariableModelVisitor variableModelVisitor;
    @Mock
    private WidgetIdVisitor widgetIdVisitor;
    private HtmlBuilderVisitor visitor;
    private static final byte[] assetsContent = new byte[0];
    private String assetSHA1;
    @Mock
    private DirectivesCollector directivesCollector;
    @Rule
    public TestResource testResource = new TestResource(HtmlGenerator.class);

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.visitor = new HtmlBuilderVisitor(this.fragmentRepository, Arrays.asList(this.pageFactory), this.requiredModulesVisitor, this.assetVisitor, this.directivesCollector, this.pageAssetRepository, this.widgetAssetRepository);
        Mockito.when((Object)this.requiredModulesVisitor.visit((Previewable)Matchers.any(Page.class))).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.pageAssetRepository.readAllBytes(Matchers.anyString(), (Asset)Matchers.any(Asset.class))).thenReturn((Object)assetsContent);
        Mockito.when((Object)this.widgetAssetRepository.readAllBytes((Asset)Matchers.any(Asset.class))).thenReturn((Object)assetsContent);
        this.assetSHA1 = DigestUtils.sha1Hex((byte[])assetsContent);
    }

    @Test
    public void should_build_a_component_html_when_visiting_a_component() throws Exception {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((Component)ComponentBuilder.aComponent("pbWidget").withReference("component-reference").withPropertyValue("property", "value").build())).isEqualToBody(this.testResource.load("component.html"));
    }

    @Test
    public void should_add_dimension_to_component() throws Exception {
        org.jsoup.nodes.Element element = CustomAssertions.toBody(this.visitor.visit((Component)ComponentBuilder.aComponent("pbWidget").withPropertyValue("property", "value").withDimensions(ResponsiveDimension.sm(3)).build()));
        CustomAssertions.assertThatHtmlBody(element.childNode(1).outerHtml()).hasClass("col-xs-12", "col-sm-3");
    }

    @Test
    public void should_build_a_container() throws GenerationException {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((Container)ContainerBuilder.aContainer().withReference("container-reference").withPropertyValue("property", "value").build())).isEqualToBody(this.testResource.load("simplecontainer.html"));
    }

    @Test
    public void should_add_rows_to_the_container() throws Exception {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((Container)ContainerBuilder.aContainer().with(RowBuilder.aRow()).withReference("container-reference").build())).isEqualToBody(this.testResource.load("containerWithRow.html"));
    }

    @Test
    public void should_build_a_repeatable_container() throws GenerationException {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((Container)ContainerBuilder.aContainer().withReference("container-reference").withPropertyValue("repeatedCollection", "json", "[\"foo\",\"bar\"]").build())).isEqualToBody(this.testResource.load("repeatedContainer.html"));
    }

    @Test
    public void should_not_build_a_repeatable_container_if_repeated_collection_is_an_empty_string() throws GenerationException {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((Container)ContainerBuilder.aContainer().withReference("container-reference").withPropertyValue("repeatedCollection", "json", "").build())).isEqualToBody(this.testResource.load("notRepeatedContainer.html"));
    }

    @Test
    public void should_add_dimension_to_the_container() throws GenerationException {
        Container container = (Container)ContainerBuilder.aContainer().withDimensions(ResponsiveDimension.xs(5), ResponsiveDimension.sm(7), ResponsiveDimension.md(9), ResponsiveDimension.lg(10)).build();
        String html = this.visitor.visit(container);
        CustomAssertions.assertThatHtmlBody(html).isEqualToBody(this.testResource.load("containerWithDimension.html"));
    }

    @Test
    public void should_add_elements_to_the_container_rows() throws Exception {
        Elements rows = CustomAssertions.toBody(this.visitor.visit(ContainerBuilder.aContainer().with(RowBuilder.aRow().with(new Element[]{ComponentBuilder.aComponent().withWidgetId("pbLabel").build()}), RowBuilder.aRow().with(new Element[]{ComponentBuilder.aComponent().withWidgetId("customLabel").build()})).build())).select(".row");
        Assertions.assertThat((int)rows.size()).isEqualTo(2);
        Assertions.assertThat((String)rows.first().select("pb-label").outerHtml()).isEqualTo((Object)"<pb-label></pb-label>");
        Assertions.assertThat((String)rows.last().select("custom-label").outerHtml()).isEqualTo((Object)"<custom-label></custom-label>");
    }

    @Test
    public void should_build_a_tabsContainer_html_when_visiting_a_tabsContainer() throws Exception {
        TabContainer tab = (TabContainer)TabContainerBuilder.aTabContainer().withId("1").with(ContainerBuilder.aContainer().withReference("first-container")).withReference("tab-container-1").build();
        TabContainer tab1 = (TabContainer)TabContainerBuilder.aTabContainer().withId("2").with(ContainerBuilder.aContainer().withReference("last-container")).withReference("tab-container-2").build();
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((TabsContainer)TabsContainerBuilder.aTabsContainer().with(tab, tab1).withReference("tabs-container-reference").build())).isEqualToBody(this.testResource.load("tabsContainerWithTwoTabs.html"));
    }

    @Test
    public void should_build_a_tab_container_bootstrap_like() throws Exception {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((TabsContainer)TabsContainerBuilder.aTabsContainer().withReference("tabs-container-reference").withDimension(4).withPropertyValue("property", "value").build())).isEqualToBody(this.testResource.load("simpleTabContainer.html"));
    }

    @Test
    public void should_add_elements_to_the_tab_container_tabs() throws Exception {
        TabContainer tab = (TabContainer)TabContainerBuilder.aTabContainer().withId("1").with(ContainerBuilder.aContainer().with(RowBuilder.aRow().with(ComponentBuilder.aParagraph().withReference("paragraph-reference"))).withReference("container-reference")).withReference("tab-reference").build();
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((TabsContainer)TabsContainerBuilder.aTabsContainer().with(tab).withReference("tabs-container-reference").build())).isEqualToBody(this.testResource.load("tabsContainerWithContent.html"));
    }

    @Test
    public void should_build_a_container_fluid_for_a_previewable() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.pageFactory.generate((Previewable)page)).thenReturn((Object)"var foo = \"bar\";");
        CustomAssertions.assertThatHtmlBody(this.visitor.build((Previewable)page, "mycontext/")).hasElement("div.container-fluid");
    }

    @Test
    public void should_generate_an_html_with_the_list_of_widgets() throws Exception {
        Page page = PageBuilder.aPage().withId("page-id").build();
        Mockito.when((Object)this.pageFactory.generate((Previewable)page)).thenReturn((Object)"var foo = \"bar\";");
        Mockito.when((Object)this.directivesCollector.buildUniqueDirectivesFiles((Previewable)page, page.getId())).thenReturn(Arrays.asList("assets/widgets.js"));
        String generatedHtml = this.visitor.build((Previewable)page, "mycontext/");
        Assertions.assertThat((String)generatedHtml).contains(new CharSequence[]{"<script src=\"assets/widgets.js\"></script>"});
        Assertions.assertThat((String)generatedHtml).contains(new CharSequence[]{"pb-model='page-id'"});
    }

    @Test
    public void should_generate_html_for_a_page() throws Exception {
        Asset assetLocal = AssetBuilder.anAsset().withOrder(1).withName("bonita.vendors.js").withExternal(false).build();
        Asset assetJquery = AssetBuilder.anAsset().withOrder(2).withName("//code.jquery.com/jquery-2.1.4.min.js").withExternal(true).build();
        Asset assetRelative = AssetBuilder.anAsset().withOrder(3).withName("bonita.min.js").withExternal(true).build();
        Page page = PageBuilder.aPage().withId("page-id").withAsset(assetRelative, assetJquery).with(ContainerBuilder.aContainer().with(RowBuilder.aRow().with(ComponentBuilder.anInput().withReference("input-reference"), ComponentBuilder.aParagraph().withReference("paragraph-reference"))).withReference("container-reference")).build();
        Mockito.when((Object)this.pageFactory.generate((Previewable)page)).thenReturn((Object)"var baz = \"qux\";");
        Mockito.when((Object)this.directivesCollector.buildUniqueDirectivesFiles((Previewable)page, page.getId())).thenReturn(Arrays.asList("assets/widgets-f8b2ef17808cccb95dbf0973e7745cd53c29c684.js"));
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{assetRelative, assetJquery, assetLocal}));
        String html = this.visitor.build((Previewable)page, "mycontext/");
        CustomAssertions.assertThatHtmlBody(html).isEqualToBody(this.testResource.load("page.html"));
        CustomAssertions.assertThatHtmlHead(html).isEqualToHead(this.testResource.load("page.html"));
    }

    @Test
    public void should_generate_html_for_a_formcontainer() throws GenerationException {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((FormContainer)FormContainerBuilder.aFormContainer().with((Container)ContainerBuilder.aContainer().withReference("container-reference").build()).withReference("formcontainer-reference").build())).isEqualToBody(this.testResource.load("formContainerSimple.html"));
    }

    @Test
    public void should_add_dimension_to_the_formcontainer() throws GenerationException {
        FormContainer formContainer = (FormContainer)FormContainerBuilder.aFormContainer().with((Container)ContainerBuilder.aContainer().withReference("container-reference").build()).withDimensions(ResponsiveDimension.xs(5), ResponsiveDimension.sm(7), ResponsiveDimension.md(9), ResponsiveDimension.lg(10)).build();
        String html = this.visitor.visit(formContainer);
        CustomAssertions.assertThatHtmlBody(html).isEqualToBody(this.testResource.load("formContainerWithDimension.html"));
    }

    @Test
    public void should_add_container_to_the_formcontainer() throws Exception {
        FormContainer formContainer = (FormContainer)FormContainerBuilder.aFormContainer().with((Container)ContainerBuilder.aContainer().with(RowBuilder.aRow().with(new Element[]{ComponentBuilder.aComponent().withWidgetId("pbLabel").withReference("component-reference").build()})).withReference("container-reference").build()).withReference("formcontainer-reference").build();
        CustomAssertions.assertThatHtmlBody(this.visitor.visit(formContainer)).isEqualToBody(this.testResource.load("formContainerWithContainer.html"));
    }

    @Test
    public void should_build_a_modal_container() throws GenerationException {
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((ModalContainer)ModalContainerBuilder.aModalContainer().with((Container)ContainerBuilder.aContainer().withReference("container-reference").build()).withReference("modal-container-reference").withPropertyValue("property", "value").withPropertyValue("modalId", "modal1").build())).isEqualToBody(this.testResource.load("modalContainer.html"));
    }

    @Test
    public void should_add_row_to_the_modal_container() throws Exception {
        ModalContainerBuilder modal = ModalContainerBuilder.aModalContainer();
        modal.withPropertyValue("modalId", "modal1");
        modal.with((Container)ContainerBuilder.aContainer().with(RowBuilder.aRow().build()).withReference("first-container").build());
        CustomAssertions.assertThatHtmlBody(this.visitor.visit(modal.build())).isEqualToBody(this.testResource.load("modalContainerWithRow.html"));
    }

    @Test
    public void should_add_extra_modules_when_widgets_needs_them() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.requiredModulesVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"needed.module"}));
        String html = this.visitor.build((Previewable)page, "");
        org.jsoup.nodes.Element head = Jsoup.parse((String)html).head();
        Assertions.assertThat((String)head.html()).contains(new CharSequence[]{"angular.module('bonitasoft.ui').requires.push('needed.module');"});
    }

    @Test
    public void should_not_add_extra_modules_when_no_widgets_needs_them() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.requiredModulesVisitor.visit((Previewable)page)).thenReturn(Collections.emptySet());
        String html = this.visitor.build((Previewable)page, "");
        org.jsoup.nodes.Element head = Jsoup.parse((String)html).head();
        Assertions.assertThat((String)head.html()).doesNotContain(new CharSequence[]{"angular.module('bonitasoft.ui').requires.push"});
    }

    @Test
    public void should_add_asset_import_in_header() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{new Asset().setName("myfile.css").setType(AssetType.CSS), new Asset().setName("http://moncdn/myfile.css").setExternal(true).setType(AssetType.CSS), new Asset().setName("myfile.js").setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id")}));
        String html = this.visitor.build((Previewable)page, "mycontext/");
        String head = Jsoup.parse((String)html).head().html();
        Assertions.assertThat((String)head).contains(new CharSequence[]{"<link rel=\"stylesheet\" href=\"assets/css/myfile.css?hash=" + this.assetSHA1 + "\">"});
        Assertions.assertThat((String)head).contains(new CharSequence[]{"<link rel=\"stylesheet\" href=\"http://moncdn/myfile.css\">"});
        Assertions.assertThat((String)head).contains(new CharSequence[]{"<script src=\"widgets/widget-id/assets/js/myfile.js?hash=" + this.assetSHA1 + "\"></script>"});
    }

    @Test
    public void should_build_rows() throws Exception {
        String html = this.visitor.build(Arrays.asList(RowBuilder.aRow().with(ComponentBuilder.aParagraph().withReference("1")).build(), RowBuilder.aRow().with(ComponentBuilder.anInput().withReference("2"), ComponentBuilder.aParagraph().withReference("3")).build()));
        CustomAssertions.assertThatHtmlBody(html).isEqualToBody(this.testResource.load("rowsWithComponents.html"));
    }

    @Test
    public void should_add_active_and_ordered_asset_import_in_header() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{new Asset().setName("myfile3.js").setOrder(3).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile2.js").setOrder(2).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile99.js").setOrder(99).setActive(false).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile4.js").setOrder(1).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("zidget-id"), new Asset().setName("myfile1.js").setOrder(0).setType(AssetType.JAVASCRIPT)}));
        String html = this.visitor.build((Previewable)page, "mycontext/");
        String head = Jsoup.parse((String)html).head().html();
        Assertions.assertThat((String)head).doesNotContain(new CharSequence[]{"myfile99.js"});
        Assertions.assertThat((String)head).contains(new CharSequence[]{"<script src=\"widgets/widget-id/assets/js/myfile2.js?hash=" + this.assetSHA1 + "\"></script> \n<script src=\"widgets/widget-id/assets/js/myfile3.js?hash=" + this.assetSHA1 + "\"></script> \n<script src=\"widgets/zidget-id/assets/js/myfile4.js?hash=" + this.assetSHA1 + "\"></script> \n<script src=\"assets/js/myfile1.js?hash=" + this.assetSHA1 + "\"></script>"});
    }

    @Test
    public void should_import_asset_only_once_for_each_widget() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{new Asset().setName("myfile5.js").setOrder(0).setType(AssetType.JAVASCRIPT), new Asset().setName("myfile2.js").setOrder(1).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile3.js").setOrder(2).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile1.js").setOrder(3).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile3.js").setOrder(4).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile2.js").setOrder(5).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id")}));
        String html = this.visitor.build((Previewable)page, "mycontext/");
        String head = Jsoup.parse((String)html).head().html();
        Assertions.assertThat((String)head).contains(new CharSequence[]{"<script src=\"widgets/widget-id/assets/js/myfile2.js?hash=" + this.assetSHA1 + "\"></script> \n<script src=\"widgets/widget-id/assets/js/myfile3.js?hash=" + this.assetSHA1 + "\"></script> \n<script src=\"widgets/widget-id/assets/js/myfile1.js?hash=" + this.assetSHA1 + "\"></script> \n<script src=\"assets/js/myfile5.js?hash=" + this.assetSHA1 + "\"></script>"});
    }

    @Test
    public void should_import_asset_only_once_globally() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn((Object)Sets.newHashSet((Object[])new Asset[]{new Asset().setName("myfile1.js").setOrder(0).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("widget-id"), new Asset().setName("myfile1.js").setOrder(1).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("zidget-id"), new Asset().setName("myfile1.js").setOrder(2).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("gidget-id"), new Asset().setName("myfile1.js").setOrder(3).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("vidget-id"), new Asset().setName("myfile1.js").setOrder(4).setType(AssetType.JAVASCRIPT).setScope(AssetScope.WIDGET).setComponentId("nidget-id")}));
        String html = this.visitor.build((Previewable)page, "mycontext/");
        String head = Jsoup.parse((String)html).head().html();
        Assertions.assertThat((String)head).contains(new CharSequence[]{"<script src=\"widgets/widget-id/assets/js/myfile1.js?hash=" + this.assetSHA1 + "\"></script> \n"});
    }

    @Test
    public void should_get_html_from_main_container_of_associated_fragment() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("fragment-id")).thenReturn((Object)FragmentBuilder.aFragment().id("fragment-id").withName("person").withVariable("aKey", VariableBuilder.aConstantVariable().value("aValue").exposed(true)).build());
        CustomAssertions.assertThatHtmlBody(this.visitor.visit((FragmentElement)FragmentElementBuilder.aFragmentElement().withFragmentId("fragment-id").withBinding("fragmentVariable1", "pageVariable1").withReference("fragment-reference").build())).isEqualToBody(this.testResource.load("fragment.html"));
    }

    @Test(expected=GenerationException.class)
    public void should_throw_generation_exception_when_associated_fragment_is_not_found() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("unknown-fragment")).thenThrow(new Throwable[]{new NotFoundException("not found")});
        this.visitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("unknown-fragment").build());
    }

    @Test(expected=GenerationException.class)
    public void should_throw_generation_exception_when_error_occurs_while_getting_associated_fragment_from_repository() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("bad-fragment")).thenThrow(new Throwable[]{new RepositoryException("error", (Throwable)new Exception())});
        this.visitor.visit(FragmentElementBuilder.aFragmentElement().withFragmentId("bad-fragment").build());
    }
}

