/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.visitor.RequiredModulesVisitor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RequiredModulesVisitorTest {
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    @InjectMocks
    private RequiredModulesVisitor requiredModulesVisitor;

    @Test
    public void should_return_empty_set_when_no_extra_modules_are_needed() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget());
        Page page = PageBuilder.aPage().with(new Element[]{component}).build();
        Set modules = this.requiredModulesVisitor.visit((Previewable)page);
        Assertions.assertThat((Iterable)modules).isEmpty();
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets() throws Exception {
        Component component = this.mockComponentFor(WidgetBuilder.aWidget().modules("aModule", "anotherModule"));
        Set modules = this.requiredModulesVisitor.visit(component);
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"aModule", "anotherModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_container() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.requiredModulesVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_container_who_has_a_required_module() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().modules("containerModule").build());
        Set modules = this.requiredModulesVisitor.visit(ContainerBuilder.aContainer().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule", "containerModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_formcontainer() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbFormContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.requiredModulesVisitor.visit(FormContainerBuilder.aFormContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_tabscontainer() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbTabsContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.requiredModulesVisitor.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1})), TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{component2}))).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_tabscontainer_who_has_a_required_module() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbTabsContainer")).thenReturn((Object)WidgetBuilder.aWidget().modules("tabContainerModule").build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.requiredModulesVisitor.visit(TabsContainerBuilder.aTabsContainer().with(TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1})), TabContainerBuilder.aTabContainer().with(ContainerBuilder.aContainer().with(new Element[]{component2}))).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule", "tabContainerModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_modal_container() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbModalContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.requiredModulesVisitor.visit(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_modal_container_who_has_a_required_module() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Mockito.when((Object)this.widgetRepository.get("pbModalContainer")).thenReturn((Object)WidgetBuilder.aWidget().modules("containerModule").build());
        Mockito.when((Object)this.widgetRepository.get("pbContainer")).thenReturn((Object)WidgetBuilder.aWidget().build());
        Set modules = this.requiredModulesVisitor.visit(ModalContainerBuilder.aModalContainer().with(ContainerBuilder.aContainer().with(new Element[]{component1, component2})).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule", "containerModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_previewable() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        Set modules = this.requiredModulesVisitor.visit((Previewable)PageBuilder.aPage().with(new Element[]{component1, component2}).build());
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule"});
    }

    @Test
    public void should_return_list_of_module_needed_by_widgets_in_fragment() throws Exception {
        Component component1 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component1Module", "component1OtherModule"));
        Component component2 = this.mockComponentFor(WidgetBuilder.aWidget().modules("component2Module", "component2OtherModule"));
        FragmentElement fragmentElement = FragmentElementBuilder.aFragmentElement().withFragmentId("my-fragment").build();
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").with(new Element[]{component1, component2}).build();
        Mockito.when((Object)this.fragmentRepository.get(fragmentElement.getId())).thenReturn((Object)fragment);
        Set modules = this.requiredModulesVisitor.visit((Previewable)fragment);
        Assertions.assertThat((Iterable)modules).containsOnly((Object[])new String[]{"component1Module", "component1OtherModule", "component2Module", "component2OtherModule"});
    }

    private Component mockComponentFor(WidgetBuilder widgetBuilder) throws Exception {
        Widget widget = widgetBuilder.id(String.valueOf(UUID.randomUUID())).build();
        Component component = ComponentBuilder.aComponent().withWidgetId(widget.getId()).build();
        Mockito.when((Object)this.widgetRepository.get(component.getId())).thenReturn((Object)widget);
        return component;
    }
}

