/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.model.data.Data;
import org.bonitasoft.web.designer.model.data.DataType;

public class DataBuilder {
    private DataType type;
    private String value;
    private boolean exposed;

    public DataBuilder(DataType type) {
        this.type = type;
    }

    public static DataBuilder aConstantData() {
        return new DataBuilder(DataType.CONSTANT);
    }

    public static DataBuilder aJSONData() {
        return new DataBuilder(DataType.JSON);
    }

    public static DataBuilder anURLData() {
        return new DataBuilder(DataType.URL);
    }

    public static DataBuilder aUrlParameterData() {
        return new DataBuilder(DataType.URLPARAMETER);
    }

    public static DataBuilder anExpressionData() {
        return new DataBuilder(DataType.EXPRESSION);
    }

    public DataBuilder value(String value) {
        this.value = value;
        return this;
    }

    public DataBuilder exposed(boolean exposed) {
        this.exposed = exposed;
        return this;
    }

    public Data build() {
        Data data = new Data(this.type, (Object)this.value);
        data.setExposed(this.exposed);
        return data;
    }
}

